<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Evidence;
use App\Models\LegalCase;

class EvidenceController extends Controller
{
    public function store(Request $request, LegalCase $case)
    {
        $request->validate([
            'title' => 'required|string',
            'type' => 'required',
            'file' => 'nullable|file|mimes:jpg,png,pdf,mp4,mp3,doc,docx|max:10240', // 10MB max
        ]);

        $path = null;
        if ($request->hasFile('file')) {
            $path = $request->file('file')->store('evidence', 'public');
        }

        $case->evidence()->create([
            'title' => $request->title,
            'reference_number' => $request->reference_number,
            'type' => $request->type,
            'storage_location' => $request->storage_location,
            'description' => $request->description,
            'file_path' => $path,
        ]);

        return back()->with('success', 'Evidence logged successfully.');
    }

    public function destroy(Evidence $evidence)
    {
        // Delete file if exists
        if ($evidence->file_path) {
            \Storage::disk('public')->delete($evidence->file_path);
        }
        $evidence->delete();
        return back()->with('success', 'Evidence removed.');
    }
}
