<?php

namespace App\Http\Controllers\SuperAdmin;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        // Load all settings into a key-value array for the view
        $settings = Setting::all()->pluck('value', 'key');

        return view('super-admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        // Loop through all inputs and save them
        // We exclude '_token' and '_method'
        foreach ($request->except(['_token', '_method']) as $key => $value) {
            Setting::set($key, $value);
        }

        return back()->with('success', 'System settings updated successfully.');
    }
}
