<?php

namespace App\Http\Controllers\Tenant;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class ImpersonationController extends Controller
{
    public function exit()
    {
        // 1. Clear the impersonation flag from the session
        Session::forget('is_impersonating');

        // 2. Log out of the tenant application
        Auth::logout();

        // 3. Redirect back to the Landlord Dashboard on the central domain
        // We pull the first central domain from your config (e.g., legalpro.test)
        $centralDomain = config('tenancy.central_domains')[0];

        return redirect('http://' . $centralDomain . '/admin/dashboard');
    }
}
