<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckTenantStatus
{
    public function handle(Request $request, Closure $next)
    {
        $tenant = tenant(); // Helper provided by stancl/tenancy

        if ($tenant && $tenant->subscription_status === 'suspended') {
            // If the firm is suspended, show them a custom "Account Locked" page
            return response()->view('errors.suspended', [], 403);
        }

        return $next($request);
    }
}
