<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    protected $fillable = ['user_id', 'action', 'module', 'description'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function record($action, $module, $description)
    {
        self::create([
            'user_id' => auth()->id() ?? 1, // Fallback to 1 if system action
            'action' => $action,
            'module' => $module,
            'description' => $description
        ]);
    }
}
