<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;

    // Fix: Add all these fields to fillable
    protected $fillable = [
        'user_id',          // <--- This was missing
        'title',
        'start_time',
        'end_time',
        'client_id',
        'legal_case_id',
        'location',
        'status',
        'notes',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function client()
    {
        return $this->belongsTo(User::class, 'client_id');
    }

    public function case()
    {
        return $this->belongsTo(LegalCase::class, 'legal_case_id');
    }

    // Helper to auto-cast dates so you can format them in Blade
    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
    ];
}
