<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CaseNote extends Model
{
    use HasFactory;

    protected $fillable = ['legal_case_id', 'user_id', 'content', 'type', 'is_visible_to_client', 'activity_date'];

    protected $casts = [
        'activity_date' => 'datetime',
        'is_visible_to_client' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
