<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Evidence extends Model
{
    use HasFactory;

    // Add this array to allow the controller to save data
    protected $fillable = [
        'legal_case_id',
        'title',
        'reference_number',
        'type',
        'storage_location',
        'file_path',
        'description',
    ];

    /**
     * Relationship back to the Case
     */
    public function legalCase()
    {
        return $this->belongsTo(LegalCase::class);
    }
}
