<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCase extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'case_number',
        'title',
        'description',
        'client_id',
        'assigned_lawyer_id',
        'status',
        'priority',
        'court_date',
        'retainer_fee',
        'court_name',
        'judge_name',
        'case_stage',
        'opposing_counsel',
        'police_station',
        'police_ob_number',
        'assigned_advocate_id',
        'ai_analysis'
    ];

    protected $casts = [
        'court_date' => 'date',
    ];

    // Relationship: Who is the client?
    public function client()
    {
        return $this->belongsTo(User::class, 'client_id');
    }

    // Relationship: Who is the lawyer?
    public function lawyer()
    {
        return $this->belongsTo(User::class, 'assigned_lawyer_id');
    }

    public function documents()
    {
        return $this->hasMany(Document::class);
    }

    public function timeline()
    {
        return $this->hasMany(CaseNote::class)->latest('activity_date');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function witnesses()
    {
        return $this->hasMany(Witness::class);
    }

    public function recordings()
    {
        return $this->hasMany(CaseRecording::class);
    }

    public function evidence()
    {
        return $this->hasMany(Evidence::class);
    }
}
