<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model {
    protected $fillable = ['invoice_id', 'amount', 'payment_date', 'method', 'transaction_ref', 'notes','chart_of_account_id'];

    public function invoice() { return $this->belongsTo(Invoice::class); }

    public function client() {
        return $this->belongsTo(User::class, 'client_id');
    }

    public function account() {
        return $this->belongsTo(ChartOfAccount::class, 'chart_of_account_id');
    }
}
