<?php

namespace App\Models;

use Stancl\Tenancy\Database\Models\Tenant as BaseTenant;
use Stancl\Tenancy\Contracts\TenantWithDatabase;
use Stancl\Tenancy\Database\Concerns\HasDatabase;
use Stancl\Tenancy\Database\Concerns\HasDomains;

class Tenant extends BaseTenant implements TenantWithDatabase
{
    use HasDatabase, HasDomains;

    /**
     * The table associated with the model.
     * (Optional, defaults to 'tenants')
     */
    protected $table = 'tenants';

    /**
     * Custom columns that should be treated as direct attributes
     * instead of being stored in the 'data' JSON column.
     */

    public static function getCustomColumns(): array
    {
        return [
            'id',
            'firm_name',
            'email', // Ensure email is here
            'plan',
            'subscription_status',
            'total_paid'
        ];
    }

    // Add fillable if you are not using the package's default guarded=[] logic
    protected $fillable = [
        'id',
        'firm_name',
        'kra_pin',
        'email',
        'plan',
        'subscription_status',
        'data', // The JSON column for extra data (logo_path, settings, etc)
    ];
}
