<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles; // <--- IMPORT THIS

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, HasRoles;

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',          // Crucial for M-Pesa/SMS notifications
        'is_active',      // To disable access for former employees
        'kra_pin',
        'role'
    ];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    public function legalCases()
    {
        // We assume the foreign key on the 'legal_cases' table is 'client_id'
        // referring to this User's ID.
        return $this->hasMany(LegalCase::class, 'client_id');
    }

    /**
     * Get all invoices through the legal cases.
     */
    public function invoices()
    {
        return $this->hasManyThrough(Invoice::class, LegalCase::class, 'client_id', 'legal_case_id');
    }

    public function isHeadOfLegal()
    {
        return $this->hasRole('head_of_legal');
    }

    // In App/Models/User.php

    public function cases()
    {
        return $this->hasMany(LegalCase::class, 'client_id');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class, 'client_id');
    }
}
