<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTenantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('tenants', function (Blueprint $table) {
            $table->string('id')->primary(); // This will be the subdomain/ID (e.g., 'smith-law')

            // Custom Columns for LegalPro
            $table->string('firm_name');
            $table->string('kra_pin')->nullable();
            $table->string('email')->index();
            $table->string('plan')->default('free');
            $table->string('subscription_status')->default('active');

            // Add these missing columns:
            $table->decimal('total_paid', 15, 2)->default(0.00);


            // Standard Tenancy Columns
            $table->json('data')->nullable(); // Stores everything else
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('tenants');
    }
}
