<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_notes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('legal_case_id')->constrained('legal_cases')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users'); // Who wrote the note?

            $table->text('content');
            $table->enum('type', ['note', 'call', 'hearing', 'email'])->default('note');
            $table->boolean('is_visible_to_client')->default(false); // For Client Portal later
            $table->timestamp('activity_date')->useCurrent(); // When did this actually happen?

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_notes');
    }
};
