<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('invoices', function (Blueprint $table) {
        $table->id();
        $table->foreignId('legal_case_id')->constrained('legal_cases')->onDelete('cascade');
        $table->string('invoice_number')->unique(); // e.g. INV-2026-001
        $table->date('due_date');
        $table->decimal('total_amount', 10, 2)->default(0);
        $table->enum('status', ['unpaid', 'paid', 'overdue'])->default('unpaid');
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
