<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('evidence', function (Blueprint $table) {
            $table->id();
            $table->foreignId('legal_case_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->string('reference_number')->nullable(); // e.g. Exhibit A
            $table->enum('type', ['Physical', 'Digital', 'Document', 'Forensic', 'Other']);
            $table->string('storage_location')->nullable(); // e.g. "Safe Box 1" or "Cloud"
            $table->string('file_path')->nullable(); // Photo of object or the file itself
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('evidence');
    }
};
