<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   public function up()
    {
        // We update the ENUM list to include 'pending_approval'
        DB::statement("ALTER TABLE invoices MODIFY COLUMN status ENUM('draft', 'unpaid', 'paid', 'overdue', 'pending_approval') DEFAULT 'draft'");
    }

    public function down()
    {
        // Revert back to original list if needed
        DB::statement("ALTER TABLE invoices MODIFY COLUMN status ENUM('draft', 'unpaid', 'paid', 'overdue') DEFAULT 'draft'");
    }
};
