<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // 1. Payments (Money In)
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
            $table->decimal('amount', 15, 2);
            $table->date('payment_date');
            $table->string('method'); // Bank, M-Pesa, Cash, Cheque
            $table->string('transaction_ref')->nullable(); // e.g., M-Pesa Code
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // 2. Credit Notes (Money Waived/Returned)
        Schema::create('credit_notes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
            $table->string('credit_number')->unique(); // CN-2026-XXXX
            $table->decimal('amount', 15, 2);
            $table->date('issued_date');
            $table->text('reason');
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('finance_tables');
    }
};
