<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-calendar-check text-indigo-600"></i>
                {{ __('Schedule & Appointments') }}
            </h2>
            <button onclick="document.getElementById('addModal').classList.remove('hidden')"
                class="bg-indigo-600 text-white px-5 py-2 rounded-xl text-sm font-bold hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition flex items-center gap-2">
                <i class="ph-bold ph-plus"></i> New Appointment
            </button>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-1 space-y-6 order-2 lg:order-2">
                    <div class="bg-white p-6 rounded-2xl shadow-sm ring-1 ring-slate-900/5">
                        <h3 class="font-bold text-slate-800 mb-4 flex items-center gap-2">
                            <i class="ph-duotone ph-clock-countdown text-indigo-500"></i> Upcoming Events
                        </h3>

                        <div class="space-y-4">
                            @foreach($appointments->where('start_time', '>=', now())->take(3) as $apt)
                                <div class="p-3 rounded-xl border-l-4 border-indigo-500 bg-indigo-50/30 hover:shadow-md transition group">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <p class="text-[10px] font-bold text-slate-400 uppercase">{{ $apt->start_time->format('M d') }} • {{ $apt->start_time->format('H:i') }}</p>
                                            <h4 class="text-sm font-bold text-slate-800">{{ $apt->title }}</h4>
                                        </div>
                                        <form action="{{ route('admin.appointments.destroy', $apt->id) }}" method="POST" onsubmit="return confirm('Cancel?');">
                                            @csrf @method('DELETE')
                                            <button class="text-slate-300 hover:text-red-500 opacity-0 group-hover:opacity-100 transition"><i class="ph-bold ph-trash"></i></button>
                                        </form>
                                    </div>
                                </div>
                            @endforeach

                            @foreach($courtDates->where('court_date', '>=', now())->take(3) as $hearing)
                                <div class="p-3 rounded-xl border-l-4 border-red-500 bg-red-50/30 hover:shadow-md transition">
                                    <div class="flex items-center gap-3">
                                        <div class="h-8 w-8 rounded bg-red-100 text-red-600 flex items-center justify-center text-lg">
                                            <i class="ph-bold ph-gavel"></i>
                                        </div>
                                        <div>
                                            <p class="text-[10px] font-bold text-red-500 uppercase">Court • {{ $hearing->court_date->format('M d @ H:i') }}</p>
                                            <h4 class="text-sm font-bold text-slate-800">{{ $hearing->case_number }}</h4>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            @if($appointments->isEmpty() && $courtDates->isEmpty())
                                <p class="text-center text-slate-400 text-sm py-4">No upcoming events.</p>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-2 order-1 lg:order-1">
                    <div class="bg-white p-6 rounded-2xl shadow-sm ring-1 ring-slate-900/5">
                        <div class="flex justify-between items-center mb-6">
                            <h3 class="font-bold text-lg text-slate-800">{{ now()->format('F Y') }}</h3>
                            <div class="flex gap-4 text-xs font-bold">
                                <span class="flex items-center gap-1"><span class="w-2 h-2 rounded-full bg-indigo-500"></span> Appointment</span>
                                <span class="flex items-center gap-1"><span class="w-2 h-2 rounded-full bg-red-500"></span> Court Date</span>
                            </div>
                        </div>

                        <div class="grid grid-cols-7 gap-px bg-slate-200 border border-slate-200 rounded-lg overflow-hidden">
                            @foreach(['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'] as $day)
                                <div class="bg-slate-50 py-2 text-center text-xs font-bold text-slate-500 uppercase tracking-wide">{{ $day }}</div>
                            @endforeach

                            @php
                                $daysInMonth = now()->daysInMonth;
                                $firstDayOfWeek = now()->startOfMonth()->dayOfWeek;
                            @endphp

                            @for($i = 0; $i < $firstDayOfWeek; $i++)
                                <div class="bg-white h-28 p-2"></div>
                            @endfor

                            @for($day = 1; $day <= $daysInMonth; $day++)
                                @php
                                    $currentDate = now()->startOfMonth()->addDays($day - 1)->format('Y-m-d');

                                    // Filter Appointments
                                    $dayAppointments = $appointments->filter(function($apt) use ($currentDate) {
                                        return $apt->start_time->format('Y-m-d') === $currentDate;
                                    });

                                    // Filter Court Dates
                                    $dayCourtDates = $courtDates->filter(function($case) use ($currentDate) {
                                        return $case->court_date->format('Y-m-d') === $currentDate;
                                    });
                                @endphp

                                <div class="bg-white h-28 p-2 border-t border-slate-50 hover:bg-slate-50 transition relative group flex flex-col gap-1 overflow-y-auto">
                                    <span class="text-sm font-bold {{ $day == now()->day ? 'bg-slate-900 text-white h-6 w-6 rounded-full flex items-center justify-center' : 'text-slate-700' }}">
                                        {{ $day }}
                                    </span>

                                    @foreach($dayCourtDates as $hearing)
                                        <a href="{{ route('admin.cases.show', $hearing->id) }}" class="block text-[10px] truncate px-1.5 py-0.5 rounded bg-red-50 text-red-700 border border-red-100 font-bold hover:bg-red-100" title="Court: {{ $hearing->case_number }}">
                                            <i class="ph-bold ph-gavel mr-1"></i> {{ $hearing->court_date->format('H:i') }} {{ $hearing->case_number }}
                                        </a>
                                    @endforeach

                                    @foreach($dayAppointments as $apt)
                                        <div class="text-[10px] truncate px-1.5 py-0.5 rounded {{ $apt->status == 'scheduled' ? 'bg-indigo-50 text-indigo-700 border border-indigo-100' : 'bg-slate-100 text-slate-500 line-through' }}" title="{{ $apt->title }}">
                                            {{ $apt->start_time->format('H:i') }} {{ $apt->title }}
                                        </div>
                                    @endforeach

                                    <button onclick="openAddModal('{{ $currentDate }}')" class="absolute bottom-1 right-1 opacity-0 group-hover:opacity-100 text-indigo-600 hover:bg-indigo-50 p-1 rounded">
                                        <i class="ph-bold ph-plus"></i>
                                    </button>
                                </div>
                            @endfor
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div id="addModal" class="fixed inset-0 z-50 hidden" style="backdrop-filter: blur(2px);">
        <div class="absolute inset-0 bg-slate-900/50" onclick="document.getElementById('addModal').classList.add('hidden')"></div>
        <div class="relative max-w-lg mx-auto mt-20 bg-white rounded-xl shadow-2xl p-6 animate-fade-in-up">
            <h3 class="text-lg font-bold text-slate-800 mb-4">Schedule Appointment</h3>
            <form action="{{ route('admin.appointments.store') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Title / Purpose</label>
                        <input type="text" name="title" class="w-full rounded-lg border-slate-200 text-sm" placeholder="e.g. Initial Consultation" required>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Date & Time Start</label>
                            <input type="datetime-local" name="start_time" id="modalStartDate" class="w-full rounded-lg border-slate-200 text-sm" required>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Date & Time End</label>
                            <input type="datetime-local" name="end_time" class="w-full rounded-lg border-slate-200 text-sm" required>
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                         <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Link Client</label>
                            <select name="client_id" class="w-full rounded-lg border-slate-200 text-sm">
                                <option value="">-- None --</option>
                                @foreach($clients as $client)
                                    <option value="{{ $client->id }}">{{ $client->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Link Case (Optional)</label>
                            <select name="legal_case_id" class="w-full rounded-lg border-slate-200 text-sm">
                                <option value="">-- None --</option>
                                @foreach($cases as $case)
                                    <option value="{{ $case->id }}">{{ $case->case_number }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Location / Link</label>
                        <input type="text" name="location" class="w-full rounded-lg border-slate-200 text-sm" placeholder="e.g. Boardroom A or Zoom Link">
                    </div>
                    <button type="submit" class="w-full bg-indigo-600 text-white py-2.5 rounded-lg font-bold hover:bg-indigo-700">Save Appointment</button>
                </div>
            </form>
            <button onclick="document.getElementById('addModal').classList.add('hidden')" class="absolute top-4 right-4 text-slate-400 hover:text-red-500">
                <i class="ph-bold ph-x text-xl"></i>
            </button>
        </div>
    </div>

    <script>
        function openAddModal(dateStr) {
            if(dateStr) {
                document.getElementById('modalStartDate').value = dateStr + 'T09:00';
            }
            document.getElementById('addModal').classList.remove('hidden');
        }
    </script>
</x-app-layout>
