<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
            <div>
                <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-3">
                    <span class="text-indigo-600">
                        <i class="ph-duotone ph-calendar-blank"></i>
                    </span>
                    {{ __('Legal Schedule') }}
                </h2>
                <p class="text-sm text-slate-500 mt-1">View upcoming court hearings and important deadlines.</p>
            </div>

            <div class="mt-4 sm:mt-0 flex gap-4">
                <div class="bg-white border border-slate-200 rounded-lg px-4 py-2 shadow-sm flex items-center gap-3">
                    <div class="h-3 w-3 rounded-full bg-red-500 ring-4 ring-red-50"></div>
                    <span class="text-xs font-bold text-slate-700 uppercase tracking-wider">Court Hearings</span>
                </div>
            </div>
        </div>
    </x-slot>

    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js'></script>

    <div class="py-8 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-4 sm:p-8">

                <div id='calendar' class="legal-calendar-custom"></div>
            </div>

            <div class="mt-6 flex items-center justify-center gap-2 text-slate-400">
                <i class="ph ph-info text-lg"></i>
                <p class="text-xs italic">All times are displayed in your local timezone.</p>
            </div>
        </div>
    </div>

    <style>
        /* Custom Overrides for FullCalendar to make it look "SaaS" professional */
        .legal-calendar-custom .fc-header-toolbar {
            margin-bottom: 2rem !important;
        }

        .legal-calendar-custom .fc-button {
            background-color: #ffffff !important;
            border: 1px solid #e2e8f0 !important;
            color: #475569 !important;
            font-weight: 600 !important;
            font-size: 0.875rem !important;
            text-transform: capitalize !important;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05) !important;
        }

        .legal-calendar-custom .fc-button-active {
            background-color: #4f46e5 !important;
            border-color: #4338ca !important;
            color: white !important;
        }

        .legal-calendar-custom .fc-button:hover {
            background-color: #f8fafc !important;
        }

        .legal-calendar-custom .fc-toolbar-title {
            font-size: 1.25rem !important;
            font-weight: 800 !important;
            color: #1e293b !important;
        }

        .legal-calendar-custom .fc-col-header-cell {
            background-color: #f8fafc !important;
            padding: 12px 0 !important;
        }

        .legal-calendar-custom .fc-col-header-cell-cushion {
            color: #64748b !important;
            font-size: 0.75rem !important;
            font-weight: 700 !important;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        /* Styling for the events */
        .fc-event {
            border-radius: 4px !important;
            padding: 2px 4px !important;
            font-weight: 500 !important;
            border: none !important;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,listWeek'
                },
                height: 'auto',
                aspectRatio: 1.8,
                eventColor: '#ef4444', // Default red for hearings
                events: "{{ route('admin.calendar.index') }}",

                // Customize the look of event rendering
                eventDidMount: function(info) {
                    if (info.event.extendedProps.description) {
                        // Simple tooltip logic
                        info.el.setAttribute('title', info.event.extendedProps.description);
                    }
                },

                // List View empty state
                noEventsContent: 'No upcoming hearings scheduled for this period.',
            });

            calendar.render();
        });
    </script>
</x-app-layout>
