<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ isset($case) ? 'Edit Case Details' : 'Open New Case' }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <form action="{{ isset($case) ? route('admin.cases.update', $case->id) : route('admin.cases.store') }}"
                method="POST">
                @csrf
                @if (isset($case))
                    @method('PUT')
                @endif

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                    <div class="lg:col-span-2 space-y-6">

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b pb-2">
                                <i class="ph-duotone ph-briefcase text-indigo-500"></i> Case Information
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="col-span-2">
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Case Title /
                                        Matter</label>
                                    <input type="text" name="title" value="{{ old('title', $case->title ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        required placeholder="e.g. Republic vs John Doe">
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Case
                                        Number</label>
                                    <input type="text" name="case_number"
                                        value="{{ old('case_number', $case->case_number ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        required placeholder="e.g. HCC/123/2026">
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Current
                                        Stage</label>
                                    <select name="case_stage"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach (['Pre-Trial', 'Mention', 'Hearing', 'Submission', 'Judgment', 'Appeal', 'Closed'] as $stage)
                                            <option value="{{ $stage }}"
                                                {{ old('case_stage', $case->case_stage ?? '') == $stage ? 'selected' : '' }}>
                                                {{ $stage }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-6">
                                    <div class="flex justify-between items-end mb-2">
                                        <label class="block text-sm font-bold text-slate-700">Case Description /
                                            Facts</label>

                                        <x-dictation-widget target="caseDescription" />
                                    </div>

                                    <textarea id="caseDescription" name="description" rows="6"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="Type or use the microphone to dictate the case details..."></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b pb-2">
                                <i class="ph-duotone ph-gavel text-indigo-500"></i> Court & Legal
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Court
                                        Name</label>
                                    <input type="text" name="court_name"
                                        value="{{ old('court_name', $case->court_name ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="e.g. Milimani Commercial">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Presiding
                                        Judge</label>
                                    <input type="text" name="judge_name"
                                        value="{{ old('judge_name', $case->judge_name ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="e.g. Hon. Justice O. M.">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Next Hearing
                                        Date</label>
                                    <input type="datetime-local" name="court_date"
                                        value="{{ old('court_date', isset($case->court_date) ? $case->court_date->format('Y-m-d\TH:i') : '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Opposing
                                        Counsel</label>
                                    <input type="text" name="opposing_counsel"
                                        value="{{ old('opposing_counsel', $case->opposing_counsel ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="Firm Name">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-6">

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b pb-2">
                                <i class="ph-duotone ph-users text-indigo-500"></i> Parties
                            </h3>

                            <div class="space-y-4">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Client</label>
                                    <select name="client_id"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}"
                                                {{ old('client_id', $case->client_id ?? '') == $client->id ? 'selected' : '' }}>
                                                {{ $client->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Assigned
                                        Advocate</label>
                                    <select name="user_id"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach ($lawyers as $lawyer)
                                            <option value="{{ $lawyer->id }}"
                                                {{ old('user_id', $case->user_id ?? Auth::id()) == $lawyer->id ? 'selected' : '' }}>
                                                {{ $lawyer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b pb-2">
                                <i class="ph-duotone ph-siren text-red-500"></i> Police Details
                            </h3>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">Police
                                        Station</label>
                                    <input type="text" name="police_station"
                                        value="{{ old('police_station', $case->police_station ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="e.g. Central">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1">OB
                                        Number</label>
                                    <input type="text" name="police_ob_number"
                                        value="{{ old('police_ob_number', $case->police_ob_number ?? '') }}"
                                        class="w-full rounded-md border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"
                                        placeholder="OB/XX/XX">
                                </div>
                            </div>
                        </div>

                        <button type="submit"
                            class="w-full bg-slate-900 text-white py-3 rounded-xl font-bold hover:bg-slate-800 transition shadow-lg">
                            {{ isset($case) ? 'Update Case File' : 'Create Case File' }}
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</x-app-layout>
