<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-pencil-simple text-indigo-600"></i>
                Edit Matter: {{ $case->case_number }}
            </h2>
            <span class="text-xs font-mono text-slate-500 bg-white px-2 py-1 rounded border">ID: #{{ $case->id }}</span>
        </div>
    </x-slot>

    <div class="py-12 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <form action="{{ route('admin.cases.update', $case->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                    <div class="lg:col-span-2 space-y-6">

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b border-slate-100 pb-2 flex items-center gap-2">
                                <i class="ph-duotone ph-briefcase text-indigo-500"></i> Case Information
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div class="col-span-2">
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Case Title / Matter</label>
                                    <input type="text" name="title" value="{{ old('title', $case->title) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-medium" required>
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Case Number</label>
                                    <input type="text" name="case_number" value="{{ old('case_number', $case->case_number) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 bg-slate-50" required>
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Current Status</label>
                                    <select name="status" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        <option value="open" {{ $case->status == 'open' ? 'selected' : '' }}>Open (Active)</option>
                                        <option value="hearing" {{ $case->status == 'hearing' ? 'selected' : '' }}>Hearing Scheduled</option>
                                        <option value="pending" {{ $case->status == 'pending' ? 'selected' : '' }}>Pending Judgment</option>
                                        <option value="closed" {{ $case->status == 'closed' ? 'selected' : '' }}>Closed / Archived</option>
                                    </select>
                                </div>

                                <div class="col-span-2">
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Description / Facts</label>
                                    <textarea name="description" rows="5"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $case->description) }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b border-slate-100 pb-2 flex items-center gap-2">
                                <i class="ph-duotone ph-gavel text-indigo-500"></i> Court & Legal Details
                            </h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Court Name</label>
                                    <input type="text" name="court_name" value="{{ old('court_name', $case->court_name) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Presiding Judge</label>
                                    <input type="text" name="judge_name" value="{{ old('judge_name', $case->judge_name) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Case Stage</label>
                                    <select name="case_stage" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach(['Pre-Trial', 'Mention', 'Hearing', 'Submission', 'Judgment', 'Appeal', 'Closed'] as $stage)
                                            <option value="{{ $stage }}" {{ (old('case_stage', $case->case_stage) == $stage) ? 'selected' : '' }}>{{ $stage }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Next Hearing Date</label>
                                    <input type="datetime-local" name="court_date"
                                        value="{{ old('court_date', $case->court_date ? $case->court_date->format('Y-m-d\TH:i') : '') }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div class="md:col-span-2">
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Opposing Counsel / Firm</label>
                                    <div class="relative">
                                        <i class="ph-bold ph-scales absolute left-3 top-2.5 text-slate-400"></i>
                                        <input type="text" name="opposing_counsel" value="{{ old('opposing_counsel', $case->opposing_counsel) }}"
                                            class="w-full pl-9 rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-6">

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b border-slate-100 pb-2 flex items-center gap-2">
                                <i class="ph-duotone ph-users text-indigo-500"></i> Parties Involved
                            </h3>

                            <div class="space-y-4">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Client</label>
                                    <select name="client_id" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ $case->client_id == $client->id ? 'selected' : '' }}>
                                                {{ $client->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Assigned Advocate</label>
                                    <select name="user_id" class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        @foreach($lawyers as $lawyer)
                                            <option value="{{ $lawyer->id }}" {{ ($case->user_id ?? $case->assigned_lawyer_id) == $lawyer->id ? 'selected' : '' }}>
                                                {{ $lawyer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                            <h3 class="text-base font-bold text-slate-800 mb-4 border-b border-slate-100 pb-2 flex items-center gap-2">
                                <i class="ph-duotone ph-siren text-red-500"></i> Police Records
                            </h3>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Police Station</label>
                                    <input type="text" name="police_station" value="{{ old('police_station', $case->police_station) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="Station Name">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">OB Number</label>
                                    <input type="text" name="police_ob_number" value="{{ old('police_ob_number', $case->police_ob_number) }}"
                                        class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-mono" placeholder="OB/XX/XX">
                                </div>
                            </div>
                        </div>

                        <div class="bg-slate-100 rounded-xl p-4 flex flex-col gap-3">
                            <button type="submit" class="w-full bg-indigo-600 text-white py-3 rounded-lg font-bold hover:bg-indigo-700 transition shadow-lg shadow-indigo-500/30 flex justify-center items-center gap-2">
                                <i class="ph-bold ph-check-circle"></i> Save Changes
                            </button>

                            <a href="{{ route('admin.cases.show', $case->id) }}" class="w-full bg-white text-slate-700 border border-slate-200 py-2.5 rounded-lg font-bold hover:bg-slate-50 transition text-center text-sm">
                                Cancel
                            </a>

                            <div class="border-t border-slate-200 my-1"></div>

                            <button type="button" onclick="if(confirm('Are you sure you want to PERMANENTLY delete this case? This cannot be undone.')) { document.getElementById('delete-form').submit(); }"
                                class="text-red-600 hover:text-red-700 text-xs font-bold flex items-center justify-center gap-1 py-2 hover:bg-red-50 rounded-lg transition">
                                <i class="ph-bold ph-trash"></i> Delete Case File
                            </button>
                        </div>

                    </div>

                </div>
            </form>

            <form id="delete-form" action="{{ route('admin.cases.destroy', $case->id) }}" method="POST" style="display: none;">
                @csrf
                @method('DELETE')
            </form>

        </div>
    </div>
</x-app-layout>
