<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-user-plus text-indigo-600"></i>
                {{ __('Onboard New Client') }}
            </h2>
            <a href="{{ route('admin.clients.index') }}"
                class="text-sm font-bold text-slate-500 hover:text-slate-800 flex items-center gap-1 transition">
                <i class="ph-bold ph-arrow-left"></i> Back to Directory
            </a>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">

            <form action="{{ route('admin.clients.store') }}" method="POST">
                @csrf

                <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden">

                    <div class="px-6 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center gap-3">
                        <div
                            class="h-10 w-10 rounded-lg bg-indigo-600 flex items-center justify-center text-white shadow-md shadow-indigo-200">
                            <i class="ph-bold ph-identification-card text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-sm font-bold text-slate-800 uppercase tracking-wider">Client Profile</h3>
                            <p class="text-xs text-slate-500">Enter personal details to create a case file account.</p>
                        </div>
                    </div>

                    <div class="p-6 space-y-6">

                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Full Name / Company
                                Name</label>
                            <div class="relative">
                                <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <i class="ph-bold ph-user text-slate-400"></i>
                                </span>
                                <input type="text" name="name" placeholder="e.g. John Doe or ACME Corp"
                                    class="w-full pl-10 rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-bold text-slate-700 placeholder-slate-400"
                                    required>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Email
                                    Address</label>
                                <div class="relative">
                                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="ph-bold ph-envelope-simple text-slate-400"></i>
                                    </span>
                                    <input type="email" name="email" placeholder="client@example.com"
                                        class="w-full pl-10 rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 text-slate-600"
                                        required>
                                </div>
                                <p class="text-[10px] text-slate-400 mt-1">Used for portal login.</p>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Phone
                                    Number</label>
                                <div class="relative">
                                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="ph-bold ph-phone text-slate-400"></i>
                                    </span>
                                    <input type="text" name="phone" placeholder="+254 7..."
                                        class="w-full pl-10 rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-mono text-slate-600"
                                        required>
                                </div>
                            </div>
                        </div>

                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Physical Address
                                <span class="text-slate-300 font-normal normal-case">(Optional)</span></label>
                            <div class="relative">
                                <span class="absolute top-3 left-3 flex items-center pointer-events-none">
                                    <i class="ph-bold ph-map-pin text-slate-400"></i>
                                </span>
                                <textarea name="address" rows="3" placeholder="Street, City, Building..."
                                    class="w-full pl-10 rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 text-slate-600 resize-none"></textarea>
                            </div>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-slate-700 mb-1">KRA PIN</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="ph-bold ph-identification-card text-slate-400"></i>
                            </div>
                            <input type="text" name="kra_pin" value="{{ old('kra_pin', $client->kra_pin ?? '') }}"
                                class="w-full pl-10 rounded-lg border-slate-200 focus:border-indigo-500 focus:ring-indigo-500 uppercase font-mono placeholder:normal-case"
                                placeholder="A00...">
                        </div>
                        <p class="text-xs text-slate-500 mt-1">Required for Tax Invoices.</p>
                    </div>

                    <div class="px-6 py-4 bg-slate-50 border-t border-slate-100 flex items-center justify-end gap-3">
                        <a href="{{ route('admin.clients.index') }}"
                            class="px-4 py-2 text-sm font-bold text-slate-500 hover:text-slate-700 transition">Cancel</a>
                        <button type="submit"
                            class="bg-indigo-600 text-white px-6 py-2.5 rounded-lg text-sm font-bold hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition transform hover:scale-105 flex items-center gap-2">
                            <i class="ph-bold ph-check-circle"></i> Create Client
                        </button>
                    </div>

                </div>
            </form>

        </div>
    </div>
</x-app-layout>
