<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-pencil-simple text-indigo-600"></i>
                Edit Client: {{ $client->name }}
            </h2>
            <a href="{{ route('admin.clients.show', $client->id) }}" class="text-sm font-bold text-slate-500 hover:text-slate-800 flex items-center gap-1 transition">
                <i class="ph-bold ph-arrow-left"></i> Back to Profile
            </a>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <form action="{{ route('admin.clients.update', $client->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden">
                    <div class="px-6 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center gap-2">
                        <i class="ph-duotone ph-identification-card text-indigo-500"></i>
                        <h3 class="text-sm font-bold text-slate-700 uppercase tracking-wider">Contact Information</h3>
                    </div>

                    <div class="p-6 space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Full Name</label>
                                <input type="text" name="name" value="{{ old('name', $client->name) }}"
                                    class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-bold text-slate-700" required>
                            </div>

                            <div>
                                <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Email Address</label>
                                <input type="email" name="email" value="{{ old('email', $client->email) }}"
                                    class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 text-slate-600" required>
                            </div>
                        </div>

                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Phone Number</label>
                            <input type="text" name="phone" value="{{ old('phone', $client->phone) }}"
                                class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 font-mono text-slate-600">
                        </div>

                        <div>
                            <label class="block text-xs font-bold text-slate-500 uppercase mb-1.5">Physical Address</label>
                            <textarea name="address" rows="3"
                                class="w-full rounded-lg border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 text-slate-600">{{ old('address', $client->address) }}</textarea>
                        </div>
                    </div>

                    <div class="bg-slate-50 px-6 py-4 flex items-center justify-end gap-3 border-t border-slate-100">
                        <a href="{{ route('admin.clients.show', $client->id) }}" class="text-sm font-bold text-slate-500 hover:text-slate-800 px-4">Cancel</a>
                        <button type="submit" class="bg-indigo-600 text-white px-6 py-2.5 rounded-lg text-sm font-bold hover:bg-indigo-700 shadow-lg shadow-indigo-200 transition transform hover:scale-105">
                            Save Changes
                        </button>
                    </div>
                </div>
            </form>

            <div class="bg-white shadow-sm ring-1 ring-red-100 sm:rounded-xl overflow-hidden border-l-4 border-red-500">
                <div class="px-6 py-5 border-b border-red-50 bg-red-50/30 flex items-center gap-2">
                    <i class="ph-duotone ph-warning-octagon text-red-500 text-xl"></i>
                    <h3 class="text-sm font-bold text-red-800 uppercase tracking-wider">Danger Zone</h3>
                </div>
                <div class="p-6 flex items-center justify-between">
                    <div>
                        <h4 class="text-sm font-bold text-slate-800">Delete Client Account</h4>
                        <p class="text-xs text-slate-500 mt-1 max-w-md">
                            This will permanently remove the client's login access.
                        </p>
                    </div>
                    <form action="{{ route('admin.clients.destroy', $client->id) }}" method="POST" onsubmit="return confirm('Are you strictly sure? This action cannot be undone.');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="bg-white border border-red-200 text-red-600 px-4 py-2 rounded-lg text-xs font-bold hover:bg-red-50 transition shadow-sm">
                            Delete Account
                        </button>
                    </form>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>
