<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                    <div class="h-10 w-10 rounded-full bg-indigo-600 text-white flex items-center justify-center text-sm font-bold shadow-md shadow-indigo-200">
                        {{ substr($client->name, 0, 1) }}
                    </div>
                    {{ $client->name }}
                </h2>
                <p class="text-sm text-slate-500 mt-1 ml-12 flex items-center gap-2">
                    Client ID: <span class="font-mono text-slate-600 bg-white border px-1.5 rounded text-xs">#{{ $client->id }}</span>
                    <span class="text-slate-300">|</span>
                    Member since {{ $client->created_at->format('M Y') }}
                </p>
            </div>

            <div class="flex items-center gap-3">
                <a href="{{ route('admin.clients.edit', $client->id) }}" class="bg-white border border-slate-300 text-slate-700 hover:bg-slate-50 hover:text-indigo-600 px-4 py-2 rounded-lg text-sm font-bold shadow-sm transition flex items-center">
                    <i class="ph-bold ph-pencil-simple mr-2"></i> Edit Profile
                </a>

                <form action="{{ route('admin.clients.destroy', $client->id) }}" method="POST" onsubmit="return confirm('Are you sure? This will delete the client login, but keep case records.');">
                    @csrf @method('DELETE')
                    <button type="submit" class="bg-red-50 border border-red-100 text-red-600 hover:bg-red-100 px-4 py-2 rounded-lg text-sm font-bold shadow-sm transition flex items-center">
                        <i class="ph-bold ph-trash mr-2"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-white p-5 rounded-xl shadow-sm ring-1 ring-slate-900/5 flex items-center gap-4 transition hover:shadow-md border-b-4 border-blue-500">
                    <div class="h-12 w-12 rounded-lg bg-blue-50 text-blue-600 flex items-center justify-center text-2xl">
                        <i class="ph-duotone ph-briefcase"></i>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Total Matters</p>
                        <h4 class="text-xl font-black text-slate-800">{{ $totalCases }}</h4>
                    </div>
                </div>

                <div class="bg-white p-5 rounded-xl shadow-sm ring-1 ring-slate-900/5 flex items-center gap-4 transition hover:shadow-md border-b-4 border-emerald-500">
                    <div class="h-12 w-12 rounded-lg bg-emerald-50 text-emerald-600 flex items-center justify-center text-2xl">
                        <i class="ph-duotone ph-pulse"></i>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Active</p>
                        <h4 class="text-xl font-black text-slate-800">{{ $activeCases }}</h4>
                    </div>
                </div>

                <div class="bg-white p-5 rounded-xl shadow-sm ring-1 ring-slate-900/5 flex items-center gap-4 transition hover:shadow-md border-b-4 border-indigo-500">
                    <div class="h-12 w-12 rounded-lg bg-indigo-50 text-indigo-600 flex items-center justify-center text-2xl">
                        <i class="ph-duotone ph-receipt"></i>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Lifetime Billed</p>
                        <h4 class="text-xl font-black text-slate-800">KES {{ number_format($totalBilled) }}</h4>
                    </div>
                </div>

                <div class="bg-white p-5 rounded-xl shadow-sm ring-1 ring-slate-900/5 flex items-center gap-4 transition hover:shadow-md border-b-4 {{ $totalUnpaid > 0 ? 'border-amber-500' : 'border-slate-200' }}">
                    <div class="h-12 w-12 rounded-lg {{ $totalUnpaid > 0 ? 'bg-amber-50 text-amber-600' : 'bg-slate-50 text-slate-400' }} flex items-center justify-center text-2xl">
                        <i class="ph-duotone ph-wallet"></i>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Due Amount</p>
                        <h4 class="text-xl font-black {{ $totalUnpaid > 0 ? 'text-amber-600' : 'text-slate-800' }}">KES {{ number_format($totalUnpaid) }}</h4>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-2 space-y-8">

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl p-6">
                        <h3 class="font-bold text-lg text-slate-800 mb-6 flex items-center gap-2">
                            <i class="ph-duotone ph-chart-bar text-indigo-500"></i> Billing History (6 Months)
                        </h3>
                        <div class="relative h-64 w-full">
                            <canvas id="clientBillingChart"></canvas>
                        </div>
                    </div>

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden">
                        <div class="px-6 py-5 border-b border-slate-100 flex justify-between items-center bg-white">
                            <h3 class="text-base font-bold text-slate-800 flex items-center gap-2">
                                <i class="ph-duotone ph-folder-open text-indigo-500"></i> Legal Matters
                            </h3>
                            <a href="{{ route('admin.cases.create') }}" class="text-xs font-bold text-indigo-600 hover:text-indigo-800 flex items-center gap-1">
                                + New Case
                            </a>
                        </div>

                        @if($client->cases->count() > 0)
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-slate-100">
                                    <thead class="bg-slate-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Case Details</th>
                                            <th class="px-6 py-3 text-left text-xs font-bold text-slate-500 uppercase tracking-wider">Status</th>
                                            <th class="px-6 py-3 text-right text-xs font-bold text-slate-500 uppercase tracking-wider">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-slate-100 bg-white">
                                        @foreach($client->cases as $case)
                                            <tr class="hover:bg-slate-50/80 transition">
                                                <td class="px-6 py-4">
                                                    <div class="flex items-center gap-3">
                                                        <div class="h-8 w-8 rounded bg-slate-100 flex items-center justify-center text-slate-500">
                                                            <i class="ph-fill ph-folder"></i>
                                                        </div>
                                                        <div>
                                                            <a href="{{ route('admin.cases.show', $case->id) }}" class="text-sm font-bold text-slate-800 hover:text-indigo-600 block">
                                                                {{ $case->title }}
                                                            </a>
                                                            <span class="text-xs font-mono text-slate-500">{{ $case->case_number }}</span>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    @if($case->status == 'open')
                                                        <span class="inline-flex items-center gap-1.5 px-2 py-1 rounded-md text-xs font-bold bg-emerald-50 text-emerald-700 border border-emerald-100">
                                                            <span class="h-1.5 w-1.5 rounded-full bg-emerald-500"></span> Active
                                                        </span>
                                                    @elseif($case->status == 'closed')
                                                        <span class="inline-flex items-center gap-1.5 px-2 py-1 rounded-md text-xs font-bold bg-slate-100 text-slate-600 border border-slate-200">
                                                            Closed
                                                        </span>
                                                    @else
                                                        <span class="inline-flex items-center gap-1.5 px-2 py-1 rounded-md text-xs font-bold bg-amber-50 text-amber-700 border border-amber-100">
                                                            {{ ucfirst($case->status) }}
                                                        </span>
                                                    @endif
                                                </td>
                                                <td class="px-6 py-4 text-right">
                                                    <a href="{{ route('admin.cases.show', $case->id) }}" class="text-slate-400 hover:text-indigo-600 font-medium text-xs">
                                                        View File <i class="ph-bold ph-arrow-right ml-1"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="p-8 text-center">
                                <p class="text-sm text-slate-500 italic">No legal matters opened for this client yet.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="lg:col-span-1 space-y-6">

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden">
                        <div class="px-5 py-4 border-b border-slate-100 bg-slate-50 flex items-center gap-2">
                            <i class="ph-duotone ph-address-book text-indigo-500"></i>
                            <h4 class="text-sm font-bold text-slate-700 uppercase tracking-wider">Contact Details</h4>
                        </div>
                        <div class="p-5 space-y-4">
                            <div>
                                <label class="block text-[10px] font-bold text-slate-400 uppercase mb-0.5">Primary Email</label>
                                <div class="flex items-center gap-2">
                                    <i class="ph-fill ph-envelope-simple text-slate-300"></i>
                                    <a href="mailto:{{ $client->email }}" class="text-sm font-medium text-indigo-600 hover:underline">
                                        {{ $client->email }}
                                    </a>
                                </div>
                            </div>

                            <div>
                                <label class="block text-[10px] font-bold text-slate-400 uppercase mb-0.5">Phone Number</label>
                                <div class="flex items-center gap-2">
                                    <i class="ph-fill ph-phone text-slate-300"></i>
                                    <span class="text-sm font-medium text-slate-700">
                                        {{ $client->phone ?? 'Not Recorded' }}
                                    </span>
                                </div>
                            </div>

                             <div>
                                <label class="block text-[10px] font-bold text-slate-400 uppercase mb-0.5">KRA PIN</label>
                                <div class="flex items-center gap-2">
                                    <i class="ph-fill ph-identification-card text-slate-300"></i>
                                    <span class="text-sm font-medium text-slate-700 font-mono">
                                        {{ $client->kra_pin ?? 'Not Recorded' }}
                                    </span>
                                </div>
                            </div>

                            <div>
                                <label class="block text-[10px] font-bold text-slate-400 uppercase mb-0.5">Physical Address</label>
                                <div class="flex items-start gap-2">
                                    <i class="ph-fill ph-map-pin text-slate-300 mt-0.5"></i>
                                    <span class="text-sm font-medium text-slate-700 leading-snug">
                                        {{ $client->address ?? 'No address on file.' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-amber-50 border border-amber-100 sm:rounded-xl p-5">
                        <h4 class="text-sm font-bold text-amber-900 mb-2 flex items-center gap-2">
                            <i class="ph-bold ph-warning-circle"></i> Account Status
                        </h4>
                        <p class="text-xs text-amber-800 leading-relaxed">
                            This client account is active. They have portal access enabled via their email address.
                        </p>
                        @if($totalUnpaid > 0)
                            <div class="mt-3 pt-3 border-t border-amber-200">
                                <p class="text-xs font-bold text-red-600">
                                    ⚠️ Client has pending invoices totaling KES {{ number_format($totalUnpaid) }}.
                                </p>
                            </div>
                        @endif
                    </div>

                </div>
            </div>

            <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-xl overflow-hidden mt-8">
                <div class="px-6 py-5 border-b border-slate-100 flex justify-between items-center bg-slate-50">
                    <h3 class="font-bold text-slate-800 flex items-center gap-2">
                        <i class="ph-duotone ph-ledger text-indigo-500"></i> Client Account Ledger
                    </h3>
                </div>
                <div class="p-6">
                    <table class="min-w-full text-left text-sm">
                        <thead>
                            <tr class="text-slate-500 border-b border-slate-100">
                                <th class="pb-3">Account Type</th>
                                <th class="pb-3 text-right">Total Received</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($client->payments && $client->payments->count() > 0)
                                @foreach($client->payments->groupBy('chart_of_account_id') as $accId => $payments)
                                    @php
                                        $account = $payments->first()->account;
                                    @endphp
                                    @if($account)
                                    <tr class="border-b border-slate-50 last:border-0">
                                        <td class="py-3">
                                            <span class="font-bold text-slate-700">{{ $account->name }}</span>
                                            <span class="text-xs text-slate-400 block">{{ ucfirst($account->type) }}</span>
                                        </td>
                                        <td class="py-3 text-right font-mono font-bold text-emerald-600">
                                            KES {{ number_format($payments->sum('amount')) }}
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="2" class="py-4 text-center text-slate-400 italic">No ledger transactions recorded yet.</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const ctx = document.getElementById('clientBillingChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: @json($chartLabels),
                datasets: [{
                    label: 'Amount Invoiced',
                    data: @json($chartValues),
                    borderColor: '#4f46e5', // Indigo-600
                    backgroundColor: 'rgba(79, 70, 229, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#fff',
                    pointBorderColor: '#4f46e5',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: { borderDash: [2, 2], color: '#f1f5f9' },
                        ticks: { font: { size: 10 } }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { font: { size: 10 } }
                    }
                },
                plugins: { legend: { display: false } }
            }
        });
    </script>
</x-app-layout>
