<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-folder-notch-open text-indigo-600"></i>
                {{ __('Digital Archive') }}
            </h2>
            <div class="text-xs font-bold text-slate-400 uppercase tracking-widest bg-white px-3 py-1 rounded-full border shadow-sm">
                Case-Centric Explorer
            </div>
        </div>
    </x-slot>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-white p-6 rounded-2xl shadow-sm ring-1 ring-slate-900/5 flex items-center gap-4">
                    <div class="h-12 w-12 rounded-xl bg-indigo-50 text-indigo-600 flex items-center justify-center text-2xl">
                        <i class="ph-duotone ph-archive"></i>
                    </div>
                    <div>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Active Archives</p>
                        <p class="text-xl font-black text-slate-800">{{ $cases->total() }} Matters</p>
                    </div>
                </div>
            </div>

            <div class="space-y-6">
                @forelse($cases as $case)
                <div class="bg-white rounded-2xl shadow-sm ring-1 ring-slate-900/5 overflow-hidden border-l-4 border-indigo-600">
                    <div class="px-6 py-4 bg-slate-50 border-b border-slate-100 flex flex-col md:flex-row md:items-center justify-between gap-4">
                        <div class="flex items-center gap-4">
                            <div class="h-10 w-10 bg-white border rounded-lg flex items-center justify-center shadow-sm">
                                <i class="ph-duotone ph-suitcase-simple text-indigo-600 text-xl"></i>
                            </div>
                            <div>
                                <h3 class="font-bold text-slate-900">{{ $case->title }}</h3>
                                <p class="text-xs font-mono text-slate-500 uppercase">{{ $case->case_number }} • Client: {{ $case->client->name }}</p>
                            </div>
                        </div>
                        <a href="{{ route('admin.cases.show', $case->id) }}" class="text-xs font-bold text-indigo-600 hover:text-indigo-800 bg-white border px-4 py-2 rounded-lg shadow-sm transition">
                            Open Case File
                        </a>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 divide-y md:divide-y-0 md:divide-x divide-slate-100">

                        <div class="p-6">
                            <h4 class="text-[11px] font-black text-blue-600 uppercase tracking-widest mb-4 flex items-center gap-2">
                                <i class="ph-bold ph-file-text"></i> Documents ({{ $case->documents->count() }})
                            </h4>
                            <div class="space-y-3">
                                @forelse($case->documents as $doc)
                                <div class="flex items-center justify-between group p-2 hover:bg-blue-50/50 rounded-xl transition">
                                    <div class="flex items-center gap-3">
                                        <i class="ph-duotone {{ $doc->file_type == 'pdf' ? 'ph-file-pdf text-red-500' : 'ph-file-doc text-blue-500' }} text-2xl"></i>
                                        <div class="min-w-0">
                                            <p class="text-sm font-bold text-slate-700 truncate w-32">{{ $doc->title }}</p>
                                            <p class="text-[10px] text-slate-400 font-mono">{{ $doc->created_at->format('d M Y') }}</p>
                                        </div>
                                    </div>
                                    <a href="{{ route('admin.documents.download', $doc->id) }}" class="p-1.5 text-slate-300 hover:text-indigo-600 opacity-0 group-hover:opacity-100 transition">
                                        <i class="ph-bold ph-download-simple"></i>
                                    </a>
                                </div>
                                @empty
                                <p class="text-xs text-slate-400 italic py-2">No documents filed.</p>
                                @endforelse
                            </div>
                        </div>

                        <div class="p-6 bg-slate-50/20">
                            <h4 class="text-[11px] font-black text-amber-600 uppercase tracking-widest mb-4 flex items-center gap-2">
                                <i class="ph-bold ph-fingerprint"></i> Evidence ({{ $case->evidence->count() }})
                            </h4>
                            <div class="space-y-3">
                                @forelse($case->evidence as $item)
                                <div class="flex items-center justify-between group p-2 hover:bg-amber-50 rounded-xl transition">
                                    <div class="flex items-center gap-3">
                                        <i class="ph-duotone {{ $item->type == 'Digital' ? 'ph-monitor-play' : 'ph-cube' }} text-amber-500 text-2xl"></i>
                                        <div class="min-w-0">
                                            <p class="text-sm font-bold text-slate-700 truncate w-32">{{ $item->title }}</p>
                                            <p class="text-[10px] text-amber-600 font-bold uppercase">{{ $item->reference_number ?? 'No Ref' }}</p>
                                        </div>
                                    </div>
                                </div>
                                @empty
                                <p class="text-xs text-slate-400 italic py-2">No evidence logged.</p>
                                @endforelse
                            </div>
                        </div>

                        <div class="p-6">
                            <h4 class="text-[11px] font-black text-rose-600 uppercase tracking-widest mb-4 flex items-center gap-2">
                                <i class="ph-bold ph-microphone-stage"></i> Audio Files ({{ $case->recordings->count() }})
                            </h4>
                            <div class="space-y-3">
                                @forelse($case->recordings as $rec)
                                <div class="flex flex-col group p-3 bg-white border border-slate-100 rounded-2xl hover:border-rose-200 hover:shadow-sm transition">
                                    <div class="flex items-center justify-between mb-2">
                                        <div class="flex items-center gap-2">
                                            <i class="ph-fill ph-waveform text-rose-500"></i>
                                            <span class="text-xs font-bold text-slate-700">{{ $rec->title }}</span>
                                        </div>
                                        <span class="text-[9px] font-mono text-slate-400">{{ $rec->created_at->diffForHumans() }}</span>
                                    </div>
                                    <audio controls class="h-8 w-full custom-audio-player">
                                        <source src="{{ Storage::disk('local')->url($rec->file_path) }}" type="audio/webm">
                                        Your browser does not support the audio element.
                                    </audio>
                                </div>
                                @empty
                                <p class="text-xs text-slate-400 italic py-2">No recordings found.</p>
                                @endforelse
                            </div>
                        </div>

                    </div>
                </div>
                @empty
                <div class="bg-white p-20 text-center rounded-3xl border border-dashed border-slate-300">
                    <i class="ph-duotone ph-folder-open text-6xl text-slate-200 mb-4"></i>
                    <h3 class="text-xl font-bold text-slate-900">Archive Empty</h3>
                </div>
                @endforelse

                <div class="mt-8">
                    {{ $cases->links() }}
                </div>
            </div>

        </div>
    </div>

    <style>
        /* Make the default audio player look a bit cleaner */
        .custom-audio-player::-webkit-media-controls-enclosure {
            border-radius: 8px;
            background-color: #fff1f2; /* rose-50 */
        }
    </style>
</x-app-layout>
