<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            New Invoice for {{ $case->case_number }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm sm:rounded-lg p-8">

                <form action="{{ route('admin.invoices.store', $case->id) }}" method="POST">
                    @csrf

                    <div class="mb-8 border-b border-gray-100 pb-6">
                        <label class="block text-gray-700 font-bold mb-2">Invoice Due Date</label>
                        <input type="date" name="due_date" class="w-1/3 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                    </div>

                    <div x-data="invoiceHandler()">

                        <div class="flex justify-between items-end mb-4">
                            <h3 class="text-lg font-bold text-gray-800">Billable Items</h3>
                            <button type="button" @click="addNewItem()" class="text-indigo-600 text-sm font-bold hover:text-indigo-800 flex items-center gap-1">
                                <i class="ph-bold ph-plus-circle"></i> Add Line Item
                            </button>
                        </div>

                        <div class="space-y-3 mb-8">
                            <div class="flex gap-4 text-xs font-bold text-gray-500 uppercase tracking-wider px-1">
                                <div class="flex-1">Description</div>
                                <div class="w-48">Amount (KES)</div>
                                <div class="w-8"></div>
                            </div>

                            <template x-for="(item, index) in items" :key="item.id">
                                <div class="flex gap-4 items-center">
                                    <div class="flex-1">
                                        <input type="text" name="descriptions[]"
                                               placeholder="e.g. Legal Research, Court Appearance"
                                               class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                                    </div>

                                    <div class="w-48">
                                        <input type="number" name="amounts[]"
                                               placeholder="0.00"
                                               class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-right" required>
                                    </div>

                                    <div class="w-8 flex justify-center">
                                        <button type="button" @click="removeItem(index)" class="text-red-400 hover:text-red-600 transition" title="Remove Line">
                                            <i class="ph-bold ph-trash text-lg"></i>
                                        </button>
                                    </div>
                                </div>
                            </template>
                        </div>

                        <div class="flex justify-end gap-4 border-t border-gray-100 pt-6">
                            <a href="{{ route('admin.cases.show', $case->id) }}" class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 font-medium hover:bg-gray-50 transition">
                                Cancel
                            </a>
                            <button type="submit" class="bg-indigo-600 text-white px-8 py-2 rounded-md font-bold hover:bg-indigo-700 shadow-md transition flex items-center gap-2">
                                <i class="ph-bold ph-check"></i> Generate Invoice
                            </button>
                        </div>

                    </div>

                </form>

            </div>
        </div>
    </div>

    <script>
        function invoiceHandler() {
            return {
                items: [
                    { id: 1 } // Start with 1 empty row
                ],
                addNewItem() {
                    this.items.push({
                        id: new Date().getTime() // Unique ID for key
                    });
                },
                removeItem(index) {
                    if (this.items.length > 1) {
                        this.items.splice(index, 1);
                    } else {
                        alert("You must have at least one item.");
                    }
                }
            }
        }
    </script>
</x-app-layout>
