<!DOCTYPE html>
<html>
<head>
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body { font-family: sans-serif; }
        .header { overflow: hidden; margin-bottom: 40px; }
        .logo { float: left; font-size: 24px; font-weight: bold; color: #333; }
        .details { float: right; text-align: right; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border-bottom: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f8f8f8; }
        .total { text-align: right; font-size: 18px; font-weight: bold; margin-top: 20px; }
        .status { color: red; font-weight: bold; text-transform: uppercase; }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo">⚖️ LAW FIRM LTD</div>
        <div class="details">
            <p>Invoice #: {{ $invoice->invoice_number }}</p>
            <p>Date: {{ $invoice->created_at->format('d M Y') }}</p>
            <p>Due: {{ $invoice->due_date->format('d M Y') }}</p>
        </div>
    </div>

    <div style="margin-bottom: 30px;">
        <strong>Bill To:</strong><br>
        {{ $invoice->legalCase->client->name }}<br>
        {{ $invoice->legalCase->client->email }}<br>
        {{ $invoice->legalCase->client->phone }}
    </div>

    <table>
        <thead>
            <tr>
                <th>Description</th>
                <th>Amount (KES)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->items as $item)
            <tr>
                <td>{{ $item->description }}</td>
                <td>{{ number_format($item->amount, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="total">
        Total: KES {{ number_format($invoice->total_amount, 2) }}
    </div>

    <div style="margin-top: 40px; font-size: 12px; color: #777;">
        <p>Please pay via M-Pesa Paybill: <strong>888888</strong> (Account: {{ $invoice->invoice_number }})</p>
    </div>
</body>
</html>
