<x-guest-layout>
    <div class="relative">
        <div class="text-center mb-8">
            <div class="relative inline-flex items-center justify-center w-20 h-20 rounded-3xl bg-indigo-600 text-white shadow-2xl shadow-indigo-200 mb-6 group overflow-hidden">
                <div class="absolute inset-0 bg-white/20 group-hover:scale-150 transition-transform duration-700 rounded-full"></div>
                <i class="ph-bold ph-identification-card text-4xl relative z-10"></i>
            </div>

            <h2 class="text-3xl font-black text-slate-900 tracking-tight">
                Partner<span class="text-indigo-600">Access</span>
            </h2>
            <div class="flex items-center justify-center gap-2 mt-2">
                <span class="h-px w-4 bg-slate-200"></span>
                <p class="text-slate-500 text-[10px] font-bold uppercase tracking-[0.2em]">Join the Modern Firm</p>
                <span class="h-px w-4 bg-slate-200"></span>
            </div>
        </div>

        <form method="POST" action="{{ route('register') }}" class="space-y-4">
            @csrf

            <div>
                <label for="name" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-1.5 px-1">Legal Name</label>
                <div class="relative group">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                        <i class="ph-bold ph-user text-xl"></i>
                    </div>
                    <input id="name" class="block w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                           type="text" name="name" :value="old('name')" required autofocus autocomplete="name" placeholder="Full legal name" />
                </div>
                <x-input-error :messages="$errors->get('name')" class="mt-1" />
            </div>

            <div>
                <label for="email" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-1.5 px-1">Professional Email</label>
                <div class="relative group">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                        <i class="ph-bold ph-envelope-simple text-xl"></i>
                    </div>
                    <input id="email" class="block w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                           type="email" name="email" :value="old('email')" required autocomplete="username" placeholder="name@firm.com" />
                </div>
                <x-input-error :messages="$errors->get('email')" class="mt-1" />
            </div>

            <div>
                <label for="kra_pin" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-1.5 px-1">KRA PIN (Compliance)</label>
                <div class="relative group">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                        <i class="ph-bold ph-hash text-xl"></i>
                    </div>
                    <input id="kra_pin" class="block w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold uppercase font-mono"
                           type="text" name="kra_pin" :value="old('kra_pin')" placeholder="A00XXXXXXXX" />
                </div>
                <p class="text-[9px] text-slate-400 mt-1 px-1 italic">Required for tax-compliant invoicing.</p>
                <x-input-error :messages="$errors->get('kra_pin')" class="mt-1" />
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 pt-2">
                <div>
                    <label for="password" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-1.5 px-1">Password</label>
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                            <i class="ph-bold ph-lock-key text-xl"></i>
                        </div>
                        <input id="password" class="block w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                               type="password" name="password" required autocomplete="new-password" placeholder="••••••••" />
                    </div>
                </div>
                <div>
                    <label for="password_confirmation" class="block text-[11px] font-extrabold text-slate-400 uppercase tracking-widest mb-1.5 px-1">Confirm</label>
                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none text-slate-400 group-focus-within:text-indigo-600 transition-colors">
                            <i class="ph-bold ph-lock-key-open text-xl"></i>
                        </div>
                        <input id="password_confirmation" class="block w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-2xl text-slate-900 placeholder-slate-400 focus:outline-none focus:bg-white focus:ring-4 focus:ring-indigo-500/10 focus:border-indigo-500 transition-all sm:text-sm font-semibold"
                               type="password" name="password_confirmation" required autocomplete="new-password" placeholder="••••••••" />
                    </div>
                </div>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-1" />

            <div class="pt-4">
                <button type="submit" class="w-full flex justify-center items-center gap-2 py-4 px-4 border border-transparent rounded-2xl shadow-xl shadow-indigo-100 text-sm font-black text-white bg-slate-900 hover:bg-indigo-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-slate-900 transition-all transform hover:-translate-y-1 active:scale-[0.98]">
                    Initialize Account <i class="ph-bold ph-sparkle"></i>
                </button>
            </div>
        </form>

        <div class="mt-8 pt-6 border-t border-slate-100 text-center">
            <p class="text-sm font-bold text-slate-400">
                Already registered?
                <a href="{{ route('login') }}" class="text-indigo-600 hover:text-indigo-800 ml-1 transition-colors underline decoration-indigo-200 underline-offset-4">
                    Sign in here
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
