<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }} - Landlord Control</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="bg-slate-50 font-sans antialiased text-slate-900">
    <div class="flex h-screen overflow-hidden">

        <x-admin-navigation />

        <main class="flex-1 flex flex-col min-w-0 overflow-hidden relative">

            <header class="bg-white/80 backdrop-blur-md border-b border-slate-200 sticky top-0 z-20">
                <div class="px-8 py-4 flex items-center justify-between">
                    <div class="flex-1 min-w-0">
                        {{ $header ?? '' }}
                    </div>

                    <div class="flex items-center gap-4 ml-6">
                        <button class="p-2 text-slate-400 hover:text-indigo-600 transition relative">
                            <i class="ph-bold ph-bell-simple text-xl"></i>
                            <span class="absolute top-2 right-2 h-2 w-2 bg-rose-500 rounded-full border border-white"></span>
                        </button>
                        <div class="h-8 w-px bg-slate-200"></div>

                        <div class="flex items-center gap-3 pl-2">
                            <div class="text-right hidden md:block">
                                <p class="text-xs font-bold text-slate-800">{{ Auth::user()->name }}</p>
                                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider">Super Admin</p>
                            </div>
                            <div class="h-10 w-10 bg-indigo-600 rounded-xl flex items-center justify-center text-white font-black shadow-lg shadow-indigo-200 ring-2 ring-white">
                                {{ substr(Auth::user()->name, 0, 1) }}
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <div class="flex-1 overflow-y-auto p-8 scroll-smooth">

                @if (session('success'))
                    <div class="mb-6 bg-emerald-50 border border-emerald-200 text-emerald-800 px-4 py-3 rounded-xl flex items-center gap-3 shadow-sm">
                        <i class="ph-fill ph-check-circle text-xl"></i>
                        <span class="font-bold text-sm">{{ session('success') }}</span>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="mb-6 bg-rose-50 border border-rose-200 text-rose-800 px-4 py-3 rounded-xl shadow-sm">
                        <ul class="list-disc list-inside text-sm font-bold">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                {{ $slot }}

                <div class="mt-12 pt-6 border-t border-slate-200 text-center">
                    <p class="text-xs text-slate-400 font-medium">
                        &copy; {{ date('Y') }} LegalPro SaaS Platform. All systems operational.
                    </p>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
