<nav class="w-72 bg-slate-900 text-slate-300 flex flex-col border-r border-slate-800 relative z-30 hidden md:flex shrink-0">
    <div class="p-8 pb-10">
        <div class="flex items-center gap-3">
            <div class="h-10 w-10 bg-indigo-500 rounded-xl flex items-center justify-center shadow-lg shadow-indigo-500/20 text-white">
                <i class="ph-fill ph-scales text-2xl"></i>
            </div>
            <div>
                <h1 class="text-white font-black text-xl tracking-tight leading-none">LegalPro</h1>
                <span class="text-[10px] font-bold text-indigo-400 uppercase tracking-widest">Landlord Panel</span>
            </div>
        </div>
    </div>

    <div class="flex-1 px-4 space-y-8 overflow-y-auto custom-scrollbar">

        <div>
            <p class="px-4 text-[10px] font-black text-slate-500 uppercase tracking-[0.2em] mb-3">Core Platform</p>
            <ul class="space-y-1">
                <li>
                    <x-admin-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" icon="ph-house">
                        Dashboard
                    </x-admin-nav-link>
                </li>
                <li>
                    <x-admin-nav-link :href="route('admin.tenants.index')" :active="request()->routeIs('admin.tenants.*')" icon="ph-buildings">
                        Law Firms
                    </x-admin-nav-link>
                </li>
            </ul>
        </div>

        <div>
            <p class="px-4 text-[10px] font-black text-slate-500 uppercase tracking-[0.2em] mb-3">Configuration</p>
            <ul class="space-y-1">
                <li>
                    <x-admin-nav-link :href="route('admin.settings.index')" :active="request()->routeIs('admin.settings.*')" icon="ph-sliders-horizontal">
                        Global Settings
                    </x-admin-nav-link>
                </li>
                <li>
                    <a href="#" class="flex items-center gap-3 px-4 py-3 text-sm font-bold text-slate-500 hover:text-slate-300 rounded-xl transition group opacity-50 cursor-not-allowed">
                        <i class="ph-bold ph-chart-pie-slice text-lg"></i>
                        <span>Analytics (Soon)</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <div class="p-4 border-t border-slate-800">
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button class="w-full flex items-center gap-3 px-4 py-3 text-sm font-bold text-slate-400 hover:bg-rose-500/10 hover:text-rose-400 rounded-xl transition group">
                <i class="ph-bold ph-sign-out text-lg group-hover:translate-x-1 transition-transform"></i>
                Sign Out
            </button>
        </form>
    </div>
</nav>
