<x-app-layout>
    <x-slot name="header">
        <h2 class="font-bold text-xl text-slate-800 leading-tight flex items-center gap-2">
            <i class="ph-duotone ph-house-line text-indigo-600"></i>
            {{ __('Client Portal') }}
        </h2>
    </x-slot>

    <div class="py-12 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <div class="bg-white p-8 rounded-2xl shadow-sm border border-slate-100 flex flex-col md:flex-row items-center justify-between gap-6">
                <div>
                    <h1 class="text-2xl font-bold text-slate-900">Welcome back, {{ Auth::user()->name }}</h1>
                    <p class="text-slate-500 mt-1">Here is the current status of your legal matters.</p>
                </div>
                <div class="flex gap-4">
                    <div class="text-center px-4 py-2 bg-indigo-50 rounded-lg">
                        <span class="block text-xl font-bold text-indigo-700">{{ $cases->count() }}</span>
                        <span class="text-xs font-bold text-indigo-400 uppercase tracking-wide">Active Cases</span>
                    </div>
                    <div class="text-center px-4 py-2 bg-emerald-50 rounded-lg">
                        <span class="block text-xl font-bold text-emerald-700">
                            {{ $cases->where('status', 'closed')->count() }}
                        </span>
                        <span class="text-xs font-bold text-emerald-400 uppercase tracking-wide">Resolved</span>
                    </div>
                </div>
            </div>

            @if($pendingInvoices->count() > 0)
                <div class="bg-amber-50 border border-amber-200 rounded-xl p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="p-2 bg-amber-100 text-amber-600 rounded-lg">
                            <i class="ph-bold ph-warning-circle text-xl"></i>
                        </div>
                        <h3 class="text-lg font-bold text-amber-900">Action Required: Pending Payments</h3>
                    </div>

                    <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                        @foreach($pendingInvoices as $invoice)
                            <div class="bg-white p-4 rounded-lg shadow-sm border border-amber-100 flex justify-between items-center">
                                <div>
                                    <p class="text-xs font-bold text-slate-400 uppercase">Invoice #{{ $invoice->invoice_number }}</p>
                                    <p class="text-lg font-bold text-slate-800">KES {{ number_format($invoice->total_amount) }}</p>
                                    <p class="text-xs text-slate-500">Due: {{ $invoice->due_date->format('d M Y') }}</p>
                                </div>
                                <a href="{{ route('admin.invoices.download', $invoice->id) }}" class="px-3 py-2 bg-slate-900 text-white text-xs font-bold rounded hover:bg-slate-700 transition">
                                    Pay Now
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-2 space-y-6">
                    <h3 class="font-bold text-lg text-slate-800 flex items-center gap-2">
                        <i class="ph-duotone ph-briefcase text-indigo-500"></i> My Legal Cases
                    </h3>

                    @forelse($cases as $case)
                        <div class="bg-white rounded-xl shadow-sm border border-slate-100 overflow-hidden hover:shadow-md transition">
                            <div class="p-6 border-b border-slate-50 flex justify-between items-start">
                                <div>
                                    <div class="flex items-center gap-2 mb-1">
                                        <span class="px-2 py-1 rounded text-xs font-bold uppercase tracking-wide
                                            {{ $case->status == 'open' ? 'bg-indigo-100 text-indigo-700' : 'bg-slate-100 text-slate-600' }}">
                                            {{ ucfirst($case->status) }}
                                        </span>
                                        <span class="text-xs text-slate-400 font-mono">{{ $case->case_number }}</span>
                                    </div>
                                    <h4 class="text-lg font-bold text-slate-900">{{ $case->title }}</h4>
                                    <p class="text-sm text-slate-500 mt-1 line-clamp-2">{{ $case->description }}</p>
                                </div>
                            </div>

                            <div class="px-6 py-4 bg-slate-50/50 flex flex-wrap gap-6 text-sm">
                                <div class="flex items-center gap-2 text-slate-600">
                                    <i class="ph-bold ph-calendar-check text-indigo-400"></i>
                                    <span>Opened: {{ $case->created_at->format('M d, Y') }}</span>
                                </div>
                                @if($case->court_date)
                                    <div class="flex items-center gap-2 text-slate-600">
                                        <i class="ph-bold ph-gavel text-red-400"></i>
                                        <span class="font-semibold text-slate-800">Hearing: {{ $case->court_date->format('M d @ H:i') }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-12 bg-white rounded-xl border border-dashed border-slate-300">
                            <i class="ph-duotone ph-folder-open text-4xl text-slate-300 mb-3"></i>
                            <p class="text-slate-500 font-medium">No active cases found.</p>
                        </div>
                    @endforelse
                </div>

                <div class="space-y-6">

                    @if($nextHearing)
                    <div class="bg-white p-6 rounded-xl shadow-sm border-l-4 border-red-500">
                        <h4 class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-3">Upcoming Hearing</h4>
                        <div class="flex items-start gap-4">
                            <div class="bg-red-50 text-red-600 p-3 rounded-lg text-center min-w-[60px]">
                                <span class="block text-xs font-bold uppercase">{{ $nextHearing->court_date->format('M') }}</span>
                                <span class="block text-xl font-bold">{{ $nextHearing->court_date->format('d') }}</span>
                            </div>
                            <div>
                                <p class="text-sm font-bold text-slate-900 line-clamp-1">{{ $nextHearing->title }}</p>
                                <p class="text-xs text-slate-500 mt-1">
                                    <i class="ph-fill ph-clock mr-1"></i> {{ $nextHearing->court_date->format('H:i A') }}
                                </p>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="bg-slate-900 text-white p-6 rounded-xl shadow-lg relative overflow-hidden">
                        <div class="relative z-10">
                            <h4 class="text-lg font-bold mb-4">Need Assistance?</h4>
                            <p class="text-slate-300 text-sm mb-6">Contact our office directly regarding your active matters.</p>

                            <ul class="space-y-3 text-sm">
                                <li class="flex items-center gap-3">
                                    <div class="bg-white/10 p-2 rounded-full"><i class="ph-fill ph-phone"></i></div>
                                    <span>+254 700 000 000</span>
                                </li>
                                <li class="flex items-center gap-3">
                                    <div class="bg-white/10 p-2 rounded-full"><i class="ph-fill ph-envelope"></i></div>
                                    <span>support@lawfirm.com</span>
                                </li>
                            </ul>
                        </div>

                        <div class="absolute -bottom-10 -right-10 w-40 h-40 bg-indigo-600 rounded-full opacity-20 blur-2xl"></div>
                    </div>

                </div>

            </div>
        </div>
    </div>
</x-app-layout>
