<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-black text-2xl text-slate-800 tracking-tight flex items-center gap-2">
                    <i class="ph-duotone ph-sliders-horizontal text-indigo-600"></i>
                    {{ __('Platform Configuration') }}
                </h2>
                <p class="text-xs text-slate-500 font-medium">Manage global parameters, payment gateways, and AI integrations.</p>
            </div>
            <div class="flex items-center gap-3">
                <span class="flex items-center gap-1.5 px-3 py-1.5 bg-emerald-50 text-emerald-700 rounded-lg text-[10px] font-black uppercase border border-emerald-100">
                    <span class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></span>
                    System Online
                </span>
            </div>
        </div>
    </x-slot>

    <div class="py-8 max-w-5xl mx-auto space-y-10 pb-24">

        <form action="{{ route('admin.settings.update') }}" method="POST" class="space-y-10">
            @csrf

            <div class="bg-white shadow-sm ring-1 ring-slate-200 sm:rounded-2xl overflow-hidden group hover:ring-indigo-300 transition-all">
                <div class="px-8 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-indigo-50 rounded-lg text-indigo-600 group-hover:bg-indigo-600 group-hover:text-white transition">
                            <i class="ph-bold ph-buildings text-xl"></i>
                        </div>
                        <h3 class="text-sm font-black text-slate-800 uppercase tracking-widest">Global Identity</h3>
                    </div>
                </div>
                <div class="p-8 grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-6">
                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">SaaS Name</label>
                        <input type="text" name="company_name" value="{{ $settings['company_name'] ?? 'LegalPro SaaS' }}"
                            class="w-full rounded-xl border-slate-200 text-sm focus:border-indigo-500 focus:ring-indigo-500 bg-slate-50 px-4 py-3 font-bold text-slate-700">
                    </div>
                    <div>
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Support Email</label>
                        <input type="email" name="company_email" value="{{ $settings['company_email'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                    </div>
                    <div>
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Support Phone</label>
                        <input type="text" name="company_phone" value="{{ $settings['company_phone'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                    </div>
                </div>
            </div>

            <div class="bg-white shadow-sm ring-1 ring-slate-200 sm:rounded-2xl overflow-hidden group hover:ring-purple-300 transition-all">
                <div class="px-8 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-purple-50 rounded-lg text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition">
                            <i class="ph-bold ph-brain text-xl"></i>
                        </div>
                        <h3 class="text-sm font-black text-slate-800 uppercase tracking-widest">AI Intelligence Gateway</h3>
                    </div>
                    <span class="text-[10px] font-bold text-purple-600 bg-purple-50 px-2 py-1 rounded">LLM Integration</span>
                </div>
                <div class="p-8 grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="p-5 rounded-2xl border border-slate-200 hover:border-blue-400 transition bg-slate-50/50">
                        <div class="flex items-center gap-3 mb-4">
                            <i class="ph-fill ph-sparkle text-blue-500 text-xl"></i>
                            <span class="font-bold text-slate-700">Google Gemini</span>
                        </div>
                        <div class="space-y-3">
                            <input type="password" name="gemini_api_key" value="{{ $settings['gemini_api_key'] ?? '' }}" placeholder="AIzaSy..."
                                class="w-full rounded-lg border-slate-200 text-xs font-mono bg-white">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="enable_gemini" value="1" {{ !empty($settings['enable_gemini']) ? 'checked' : '' }} class="rounded text-blue-600 focus:ring-blue-500">
                                <span class="text-xs font-bold text-slate-500">Enable Processing</span>
                            </label>
                        </div>
                    </div>
                    <div class="p-5 rounded-2xl border border-slate-200 hover:border-emerald-400 transition bg-slate-50/50">
                        <div class="flex items-center gap-3 mb-4">
                            <i class="ph-fill ph-aperture text-emerald-500 text-xl"></i>
                            <span class="font-bold text-slate-700">OpenAI (GPT-4)</span>
                        </div>
                        <div class="space-y-3">
                            <input type="password" name="openai_api_key" value="{{ $settings['openai_api_key'] ?? '' }}" placeholder="sk-..."
                                class="w-full rounded-lg border-slate-200 text-xs font-mono bg-white">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="enable_openai" value="1" {{ !empty($settings['enable_openai']) ? 'checked' : '' }} class="rounded text-emerald-600 focus:ring-emerald-500">
                                <span class="text-xs font-bold text-slate-500">Enable Models</span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow-sm ring-1 ring-slate-200 sm:rounded-2xl overflow-hidden group hover:ring-sky-300 transition-all">
                <div class="px-8 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-sky-50 rounded-lg text-sky-600 group-hover:bg-sky-600 group-hover:text-white transition">
                            <i class="ph-bold ph-cloud-arrow-up text-xl"></i>
                        </div>
                        <h3 class="text-sm font-black text-slate-800 uppercase tracking-widest">Cloud Object Storage</h3>
                    </div>
                </div>
                <div class="p-8 grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="md:col-span-1">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Provider</label>
                        <select name="storage_driver" class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                            <option value="local" {{ ($settings['storage_driver'] ?? '') == 'local' ? 'selected' : '' }}>Local Disk</option>
                            <option value="s3" {{ ($settings['storage_driver'] ?? '') == 's3' ? 'selected' : '' }}>Amazon S3</option>
                            <option value="wasabi" {{ ($settings['storage_driver'] ?? '') == 'wasabi' ? 'selected' : '' }}>Wasabi</option>
                        </select>
                    </div>
                    <div class="md:col-span-1">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Bucket Name</label>
                        <input type="text" name="storage_bucket" value="{{ $settings['storage_bucket'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                    </div>
                    <div class="md:col-span-1">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Region</label>
                        <input type="text" name="storage_region" value="{{ $settings['storage_region'] ?? 'us-east-1' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                    </div>
                    <div class="md:col-span-3 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Access Key ID</label>
                            <input type="text" name="storage_key" value="{{ $settings['storage_key'] ?? '' }}"
                                class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3 font-mono">
                        </div>
                        <div>
                            <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Secret Access Key</label>
                            <input type="password" name="storage_secret" value="{{ $settings['storage_secret'] ?? '' }}"
                                class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3 font-mono">
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white shadow-sm ring-1 ring-slate-200 sm:rounded-2xl overflow-hidden group hover:ring-emerald-300 transition-all">
                <div class="px-8 py-5 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-emerald-50 rounded-lg text-emerald-600 group-hover:bg-emerald-600 group-hover:text-white transition">
                            <i class="ph-bold ph-wallet text-xl"></i>
                        </div>
                        <h3 class="text-sm font-black text-slate-800 uppercase tracking-widest">M-Pesa Payment Gateway</h3>
                    </div>
                    <div class="flex items-center gap-2">
                        <span class="h-2 w-2 rounded-full {{ ($settings['mpesa_env'] ?? '') == 'production' ? 'bg-emerald-500' : 'bg-amber-500' }}"></span>
                        <span class="text-[10px] font-bold uppercase text-slate-500">{{ ($settings['mpesa_env'] ?? 'sandbox') }}</span>
                    </div>
                </div>
                <div class="p-8 grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-6">
                    <div>
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Environment</label>
                        <select name="mpesa_env" class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3">
                            <option value="sandbox" {{ ($settings['mpesa_env'] ?? '') == 'sandbox' ? 'selected' : '' }}>Sandbox</option>
                            <option value="production" {{ ($settings['mpesa_env'] ?? '') == 'production' ? 'selected' : '' }}>Production</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Shortcode (Paybill)</label>
                        <input type="text" name="mpesa_shortcode" value="{{ $settings['mpesa_shortcode'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3 font-mono">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Consumer Key</label>
                        <input type="password" name="mpesa_consumer_key" value="{{ $settings['mpesa_consumer_key'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3 font-mono">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">Consumer Secret</label>
                        <input type="password" name="mpesa_consumer_secret" value="{{ $settings['mpesa_consumer_secret'] ?? '' }}"
                            class="w-full rounded-xl border-slate-200 text-sm bg-slate-50 px-4 py-3 font-mono">
                    </div>
                </div>
            </div>

            <div class="fixed bottom-6 right-6 z-40">
                <button type="submit" class="shadow-2xl shadow-indigo-900/20 bg-slate-900 text-white px-8 py-4 rounded-full font-bold hover:bg-indigo-600 transition-all flex items-center gap-3 transform hover:scale-105">
                    <i class="ph-bold ph-floppy-disk text-xl"></i>
                    <span>Save Configuration</span>
                </button>
            </div>

        </form>
    </div>
</x-admin-layout>
