<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-bold text-2xl text-slate-800 leading-tight flex items-center gap-2">
                <i class="ph-duotone ph-crown text-indigo-600"></i>
                <?php echo e(__('Executive Overview')); ?>

            </h2>
            <div class="flex gap-3">
                <a href="<?php echo e(route('admin.finance.index')); ?>" class="text-sm font-bold text-indigo-600 bg-indigo-50 px-3 py-1.5 rounded-lg border border-indigo-100 hover:bg-indigo-100 transition flex items-center gap-2">
                    <i class="ph-bold ph-currency-dollar"></i> Go to Finance
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-10 bg-slate-50 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-8">

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">

                <div class="bg-white rounded-2xl p-6 shadow-sm ring-1 ring-slate-900/5 border-b-4 border-emerald-500 transition hover:shadow-md">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Firm Income</p>
                            <h4 class="text-2xl font-black text-slate-800 mt-2">KES <?php echo e(number_format($totalIncome)); ?></h4>
                        </div>
                        <div class="h-10 w-10 bg-emerald-50 text-emerald-600 rounded-lg flex items-center justify-center text-xl">
                            <i class="ph-duotone ph-trend-up"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl p-6 shadow-sm ring-1 ring-slate-900/5 border-b-4 border-red-500 transition hover:shadow-md">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Expenses</p>
                            <h4 class="text-2xl font-black text-slate-800 mt-2">KES <?php echo e(number_format($totalExpenses)); ?></h4>
                        </div>
                        <div class="h-10 w-10 bg-red-50 text-red-600 rounded-lg flex items-center justify-center text-xl">
                            <i class="ph-duotone ph-trend-down"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl p-6 shadow-sm ring-1 ring-slate-900/5 border-b-4 border-indigo-500 transition hover:shadow-md">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Net Profit</p>
                            <h4 class="text-2xl font-black <?php echo e($netProfit >= 0 ? 'text-indigo-700' : 'text-red-600'); ?> mt-2">
                                KES <?php echo e(number_format($netProfit)); ?>

                            </h4>
                        </div>
                        <div class="h-10 w-10 bg-indigo-50 text-indigo-600 rounded-lg flex items-center justify-center text-xl">
                            <i class="ph-duotone ph-wallet"></i>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl p-6 shadow-sm ring-1 ring-slate-900/5 border-b-4 border-amber-500 transition hover:shadow-md">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Client Trust Funds</p>
                            <h4 class="text-2xl font-black text-slate-800 mt-2">KES <?php echo e(number_format($clientFunds)); ?></h4>
                        </div>
                        <div class="h-10 w-10 bg-amber-50 text-amber-600 rounded-lg flex items-center justify-center text-xl">
                            <i class="ph-duotone ph-lock-key"></i>
                        </div>
                    </div>
                    <p class="text-[10px] text-slate-400 mt-2">Held in liability accounts.</p>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

                <div class="lg:col-span-2 space-y-8">
                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6">
                        <div class="flex justify-between items-center mb-6">
                            <h3 class="font-bold text-lg text-slate-800 flex items-center gap-2">
                                <i class="ph-duotone ph-chart-line-up text-indigo-500"></i> Cash Flow (6 Months)
                            </h3>
                        </div>
                        <div class="relative h-72 w-full">
                            <canvas id="adminRevenueChart"></canvas>
                        </div>
                    </div>

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6">
                        <div class="flex justify-between items-center mb-6">
                            <h3 class="font-bold text-lg text-slate-800 flex items-center gap-2">
                                <i class="ph-duotone ph-list-dashes text-slate-500"></i> System Audit Log
                            </h3>
                        </div>
                        <div class="flow-root">
                            <ul role="list" class="-mb-8">
                                <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li>
                                        <div class="relative pb-8">
                                            <?php if(!$loop->last): ?>
                                                <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-slate-200" aria-hidden="true"></span>
                                            <?php endif; ?>
                                            <div class="relative flex space-x-3">
                                                <?php
                                                    $colorClass = match ($log->action) {
                                                        'Create' => 'bg-emerald-100 text-emerald-600 ring-emerald-50',
                                                        'Delete' => 'bg-red-100 text-red-600 ring-red-50',
                                                        'Update' => 'bg-amber-100 text-amber-600 ring-amber-50',
                                                        'Login' => 'bg-blue-50 text-blue-500 ring-blue-50',
                                                        default => 'bg-slate-100 text-slate-500 ring-slate-50',
                                                    };
                                                    $iconClass = match ($log->action) {
                                                        'Create' => 'ph-plus-circle',
                                                        'Delete' => 'ph-trash',
                                                        'Update' => 'ph-pencil-simple',
                                                        'Login' => 'ph-sign-in',
                                                        default => 'ph-activity',
                                                    };
                                                ?>

                                                <div class="h-8 w-8 rounded-full flex items-center justify-center ring-4 ring-white shadow-sm z-10 <?php echo e($colorClass); ?>">
                                                    <i class="ph-bold <?php echo e($iconClass); ?>"></i>
                                                </div>
                                                <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                    <div>
                                                        <p class="text-sm text-slate-600">
                                                            <span class="font-bold text-slate-900"><?php echo e($log->user->name ?? 'System'); ?></span>
                                                            <span class="text-slate-400 mx-1">•</span>
                                                            <?php echo e($log->description); ?>

                                                        </p>
                                                    </div>
                                                    <div class="text-right text-xs text-slate-400 whitespace-nowrap font-mono">
                                                        <?php echo e($log->created_at->diffForHumans()); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <li class="text-center py-8 text-slate-400 italic">No logs available.</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-1 space-y-8">

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6">
                        <h3 class="font-bold text-lg text-slate-800 mb-4 flex items-center gap-2">
                            <i class="ph-duotone ph-books text-indigo-500"></i> Top Accounts
                        </h3>
                        <div class="space-y-4">
                            <?php $__currentLoopData = $topAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div>
                                    <div class="flex justify-between items-center mb-1">
                                        <span class="text-xs font-bold text-slate-600"><?php echo e($acc->name); ?></span>
                                        <span class="text-xs font-mono font-bold
                                            <?php echo e($acc->type == 'income' ? 'text-emerald-600' :
                                              ($acc->type == 'expense' ? 'text-red-600' : 'text-slate-600')); ?>">
                                            KES <?php echo e(number_format($acc->payments_sum_amount)); ?>

                                        </span>
                                    </div>
                                    <div class="w-full bg-slate-100 rounded-full h-1.5">
                                        <div class="h-1.5 rounded-full <?php echo e($acc->type == 'income' ? 'bg-emerald-500' : ($acc->type == 'expense' ? 'bg-red-500' : 'bg-slate-500')); ?>"
                                             style="width: <?php echo e($totalIncome > 0 ? ($acc->payments_sum_amount / ($totalIncome + $totalExpenses)) * 100 : 0); ?>%">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="mt-6 pt-4 border-t border-slate-100 text-center">
                            <a href="<?php echo e(route('admin.finance.accounts')); ?>" class="text-xs font-bold text-indigo-600 hover:text-indigo-800">
                                View Full Ledger &rarr;
                            </a>
                        </div>
                    </div>

                    <div class="bg-white shadow-sm ring-1 ring-slate-900/5 sm:rounded-2xl p-6">
                        <h3 class="font-bold text-lg text-slate-800 mb-4">Firm Operations</h3>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="bg-indigo-50 p-4 rounded-xl text-center">
                                <h4 class="text-2xl font-black text-indigo-700"><?php echo e($activeCases); ?></h4>
                                <p class="text-xs font-bold text-indigo-600/70 uppercase">Active Cases</p>
                            </div>
                            <div class="bg-red-50 p-4 rounded-xl text-center">
                                <h4 class="text-2xl font-black text-red-700"><?php echo e($hearingsThisWeek); ?></h4>
                                <p class="text-xs font-bold text-red-600/70 uppercase">Hearings (7d)</p>
                            </div>
                        </div>
                        <div class="mt-4 space-y-2">
                            <a href="<?php echo e(route('admin.cases.create')); ?>" class="block w-full text-center py-2.5 bg-slate-900 text-white text-xs font-bold rounded-xl hover:bg-slate-800 transition">
                                + Open New Case
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const ctx = document.getElementById('adminRevenueChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($months, 15, 512) ?>,
                datasets: [
                    {
                        label: 'Income',
                        data: <?php echo json_encode($incomeData, 15, 512) ?>,
                        backgroundColor: '#10b981', // Emerald-500
                        borderRadius: 4,
                        barPercentage: 0.6,
                    },
                    {
                        label: 'Expenses',
                        data: <?php echo json_encode($expenseData, 15, 512) ?>,
                        backgroundColor: '#ef4444', // Red-500
                        borderRadius: 4,
                        barPercentage: 0.6,
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: { borderDash: [2, 2], color: '#f1f5f9' },
                        ticks: { font: { size: 10 } }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { font: { size: 10 } }
                    }
                },
                plugins: {
                    legend: { position: 'bottom' }
                }
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /Users/yousaf/Documents/GitHub/law-firm-project/resources/views/super-admin/index.blade.php ENDPATH**/ ?>