<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e(config('app.name', 'LegalPro')); ?> - Premium Practice Management</title>

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700,800&display=swap" rel="stylesheet" />
        <script src="https://unpkg.com/@phosphor-icons/web"></script>

        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-sans antialiased text-slate-600 bg-white selection:bg-indigo-500 selection:text-white">

        <nav class="fixed w-full z-50 transition-all duration-300 bg-white/90 backdrop-blur-md border-b border-slate-100">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-20">
                    <div class="flex-shrink-0 flex items-center gap-2">
                        <div class="bg-indigo-600 text-white p-2 rounded-lg shadow-lg shadow-indigo-200">
                            <i class="ph-bold ph-scales text-xl"></i>
                        </div>
                        <span class="font-extrabold text-2xl text-slate-900 tracking-tight">Legal<span class="text-indigo-600">Pro</span></span>
                    </div>

                    <div class="hidden md:flex items-center space-x-10">
                        <a href="#features" class="text-sm font-bold text-slate-600 hover:text-indigo-600 transition">Features</a>
                        <a href="#finance" class="text-sm font-bold text-slate-600 hover:text-indigo-600 transition">Finance</a>
                        <?php if(Route::has('login')): ?>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(url('/dashboard')); ?>" class="bg-indigo-600 text-white px-6 py-2.5 rounded-full text-sm font-bold hover:bg-indigo-700 transition shadow-lg shadow-indigo-200">Go to Dashboard</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="text-sm font-bold text-slate-600 hover:text-indigo-600 transition">Staff Login</a>
                                <a href="<?php echo e(route('register')); ?>" class="bg-slate-900 text-white px-6 py-2.5 rounded-full text-sm font-bold hover:bg-slate-800 transition shadow-lg shadow-slate-200">
                                    Start Demo
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>

        <div class="relative pt-32 pb-20 lg:pt-48 lg:pb-32 overflow-hidden bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <div>
                        <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-indigo-50 border border-indigo-100 text-indigo-700 text-[10px] font-bold uppercase tracking-widest mb-6">
                            <i class="ph-fill ph-sparkle"></i> AI-Powered Law Practice
                        </div>

                        <h1 class="text-5xl md:text-7xl font-black text-slate-900 tracking-tight mb-6 leading-[1.1]">
                            Win More Cases with <span class="text-indigo-600">Intelligence.</span>
                        </h1>

                        <p class="text-xl text-slate-500 mb-10 leading-relaxed max-w-xl">
                            The first practice management system with an integrated **AI Co-Counsel** and a resilient **Hybrid Finance Engine** designed for modern firms.
                        </p>

                        <div class="flex flex-col sm:flex-row items-center gap-4">
                            <a href="<?php echo e(route('register')); ?>" class="w-full sm:w-auto px-10 py-5 bg-indigo-600 text-white rounded-2xl font-bold text-lg shadow-2xl shadow-indigo-200 hover:bg-indigo-700 transition transform hover:-translate-y-1 flex items-center justify-center gap-2">
                                Get Started Free <i class="ph-bold ph-arrow-right"></i>
                            </a>
                            <a href="#features" class="w-full sm:w-auto px-10 py-5 bg-white text-slate-700 border border-slate-200 rounded-2xl font-bold text-lg hover:bg-slate-50 transition flex items-center justify-center gap-2">
                                <i class="ph-bold ph-play-circle text-2xl text-indigo-600"></i> See Features
                            </a>
                        </div>
                    </div>

                    <div class="relative">
                        <div class="bg-slate-900 rounded-3xl p-4 shadow-2xl transform lg:rotate-3">
                            <div class="bg-slate-800 rounded-2xl overflow-hidden aspect-video flex items-center justify-center border border-slate-700">
                                <i class="ph-duotone ph-layout text-6xl text-slate-600"></i>
                                <span class="absolute bottom-6 left-6 text-indigo-400 font-mono text-xs">// System_Version_2.6_Live</span>
                            </div>
                        </div>
                        <div class="absolute -top-6 -right-6 bg-white p-6 rounded-2xl shadow-xl border border-slate-100 hidden md:block animate-bounce animation-delay-2000">
                            <div class="flex items-center gap-3">
                                <div class="h-10 w-10 bg-emerald-100 text-emerald-600 rounded-full flex items-center justify-center">
                                    <i class="ph-bold ph-check"></i>
                                </div>
                                <div>
                                    <p class="text-xs font-bold text-slate-400 uppercase tracking-tighter">Status</p>
                                    <p class="text-sm font-bold text-slate-800">Payment Verified</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="absolute top-0 left-1/2 -translate-x-1/2 -z-10 opacity-40 blur-3xl w-full h-full pointer-events-none">
                <div class="absolute top-20 left-10 w-96 h-96 bg-purple-200 rounded-full mix-blend-multiply filter blur-xl animate-blob"></div>
                <div class="absolute top-20 right-10 w-96 h-96 bg-indigo-200 rounded-full mix-blend-multiply filter blur-xl animate-blob animation-delay-2000"></div>
                <div class="absolute bottom-20 left-1/4 w-96 h-96 bg-blue-200 rounded-full mix-blend-multiply filter blur-xl animate-blob animation-delay-4000"></div>
            </div>
        </div>

        <div class="bg-slate-900 py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-wrap justify-center gap-8 md:gap-16 opacity-60 grayscale hover:grayscale-0 transition duration-500">
                    <span class="text-white font-bold flex items-center gap-2"><i class="ph-bold ph-shield-check text-indigo-400"></i> Kenya KRA Compliant</span>
                    <span class="text-white font-bold flex items-center gap-2"><i class="ph-bold ph-bank text-indigo-400"></i> M-Pesa Ready</span>
                    <span class="text-white font-bold flex items-center gap-2"><i class="ph-bold ph-scales text-indigo-400"></i> LSK Practice Standards</span>
                    <span class="text-white font-bold flex items-center gap-2"><i class="ph-bold ph-book-open text-indigo-400"></i> Kenyan Constitution (2010)</span>
                </div>
            </div>
        </div>

        <section id="features" class="py-32 bg-slate-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center max-w-3xl mx-auto mb-20">
                    <h2 class="text-4xl font-black text-slate-900 mb-6">Built for High-Stakes Practice.</h2>
                    <p class="text-lg text-slate-500 leading-relaxed">We didn't just build a database; we built a workflow that understands the law.</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <div class="bg-white p-10 rounded-3xl shadow-sm border border-slate-100 hover:border-indigo-200 hover:shadow-xl transition duration-300">
                        <div class="w-14 h-14 bg-indigo-50 rounded-2xl flex items-center justify-center text-indigo-600 mb-8">
                            <i class="ph-duotone ph-sparkle text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-black text-slate-900 mb-4">AI Co-Counsel</h3>
                        <p class="text-slate-500 leading-relaxed mb-6">
                            Analyze case facts instantly. Our hybrid AI tries local models (Ollama) first, then falls back to Gemini & OpenAI for the most accurate legal strategy.
                        </p>
                        <ul class="space-y-3 text-sm font-bold text-slate-600">
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-indigo-500"></i> Witness Statement Analysis</li>
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-indigo-500"></i> Automatic Memo Generation</li>
                        </ul>
                    </div>

                    <div class="bg-white p-10 rounded-3xl shadow-sm border border-slate-100 hover:border-emerald-200 hover:shadow-xl transition duration-300">
                        <div class="w-14 h-14 bg-emerald-50 rounded-2xl flex items-center justify-center text-emerald-600 mb-8">
                            <i class="ph-duotone ph-bank text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-black text-slate-900 mb-4">Financial Ledger</h3>
                        <p class="text-slate-500 leading-relaxed mb-6">
                            Professionally manage Chart of Accounts. Distinguish between Firm Income and Client Trust Funds (Judgment Sums) with ease.
                        </p>
                        <ul class="space-y-3 text-sm font-bold text-slate-600">
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-emerald-500"></i> KRA PIN Billing</li>
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-emerald-500"></i> Automated Credit Notes</li>
                        </ul>
                    </div>

                    <div class="bg-white p-10 rounded-3xl shadow-sm border border-slate-100 hover:border-red-200 hover:shadow-xl transition duration-300">
                        <div class="w-14 h-14 bg-red-50 rounded-2xl flex items-center justify-center text-red-600 mb-8">
                            <i class="ph-duotone ph-fingerprint text-3xl"></i>
                        </div>
                        <h3 class="text-2xl font-black text-slate-900 mb-4">Evidence Locker</h3>
                        <p class="text-slate-500 leading-relaxed mb-6">
                            Securely store digital evidence, record voice notes directly in the browser, and track chain of custody for every matter.
                        </p>
                        <ul class="space-y-3 text-sm font-bold text-slate-600">
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-red-500"></i> In-browser Voice Recording</li>
                            <li class="flex items-center gap-2"><i class="ph-bold ph-check text-red-500"></i> Exhibit Reference Tracking</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <div class="py-24 bg-indigo-600 relative overflow-hidden">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
                <h2 class="text-4xl font-black text-white mb-6">Ready to upgrade your practice?</h2>
                <p class="text-indigo-100 text-lg mb-10">Join modern African law firms leveraging AI for better legal outcomes.</p>
                <div class="flex flex-col sm:flex-row justify-center gap-4">
                    <a href="<?php echo e(route('register')); ?>" class="px-8 py-4 bg-white text-indigo-600 rounded-xl font-black text-lg hover:bg-indigo-50 transition shadow-xl">Create Free Account</a>
                    <a href="mailto:contact@legalpro.com" class="px-8 py-4 bg-indigo-700 text-white rounded-xl font-bold text-lg hover:bg-indigo-800 transition">Contact Sales</a>
                </div>
            </div>
            <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(#fff 1px, transparent 1px); background-size: 20px 20px;"></div>
        </div>

        <footer class="bg-white border-t border-slate-100 pt-20 pb-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-2 md:grid-cols-4 gap-12 mb-16">
                    <div class="col-span-2">
                        <div class="flex items-center gap-2 mb-6">
                            <div class="bg-indigo-600 text-white p-1.5 rounded-md">
                                <i class="ph-bold ph-scales text-lg"></i>
                            </div>
                            <span class="font-bold text-2xl text-slate-900 tracking-tight">Legal<span class="text-indigo-600">Pro</span></span>
                        </div>
                        <p class="text-slate-500 text-sm max-w-xs leading-relaxed">
                            Built in Nairobi for the modern African law firm. Secure, compliant, and powered by the latest AI technologies.
                        </p>
                    </div>
                    <div>
                        <h4 class="font-bold text-slate-900 mb-6 uppercase text-xs tracking-widest">Platform</h4>
                        <ul class="space-y-4 text-sm font-medium text-slate-500">
                            <li><a href="#" class="hover:text-indigo-600 transition">Case Management</a></li>
                            <li><a href="#" class="hover:text-indigo-600 transition">AI Co-Counsel</a></li>
                            <li><a href="#" class="hover:text-indigo-600 transition">Financial Ledger</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-bold text-slate-900 mb-6 uppercase text-xs tracking-widest">Connect</h4>
                        <ul class="space-y-4 text-sm font-medium text-slate-500">
                            <li><a href="#" class="hover:text-indigo-600 transition">LinkedIn</a></li>
                            <li><a href="#" class="hover:text-indigo-600 transition">Twitter (X)</a></li>
                            <li><a href="#" class="hover:text-indigo-600 transition">Support Center</a></li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-slate-100 pt-10 flex flex-col md:flex-row justify-between items-center text-xs text-slate-400 font-medium">
                    <p>&copy; <?php echo e(date('Y')); ?> LegalPro Systems Kenya. All rights reserved.</p>
                    <div class="flex space-x-8 mt-6 md:mt-0">
                        <a href="#" class="hover:text-indigo-600">Privacy Policy</a>
                        <a href="#" class="hover:text-indigo-600">Terms of Service</a>
                    </div>
                </div>
            </div>
        </footer>

        <style>
            .animate-blob { animation: blob 7s infinite; }
            .animation-delay-2000 { animation-delay: 2s; }
            .animation-delay-4000 { animation-delay: 4s; }
            @keyframes blob {
                0% { transform: translate(0px, 0px) scale(1); }
                33% { transform: translate(30px, -50px) scale(1.1); }
                66% { transform: translate(-20px, 20px) scale(0.9); }
                100% { transform: translate(0px, 0px) scale(1); }
            }
        </style>
    </body>
</html>
<?php /**PATH /Users/yousaf/Documents/GitHub/law-firm-project/resources/views/welcome.blade.php ENDPATH**/ ?>