<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?> - Landlord Control</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="bg-slate-50 font-sans antialiased text-slate-900">
    <div class="flex h-screen overflow-hidden">

        <?php if (isset($component)) { $__componentOriginald4f2c5a8a855d7eaab370019aec68dd9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-navigation','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-navigation'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9)): ?>
<?php $attributes = $__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9; ?>
<?php unset($__attributesOriginald4f2c5a8a855d7eaab370019aec68dd9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald4f2c5a8a855d7eaab370019aec68dd9)): ?>
<?php $component = $__componentOriginald4f2c5a8a855d7eaab370019aec68dd9; ?>
<?php unset($__componentOriginald4f2c5a8a855d7eaab370019aec68dd9); ?>
<?php endif; ?>

        <main class="flex-1 flex flex-col min-w-0 overflow-hidden relative">

            <header class="bg-white/80 backdrop-blur-md border-b border-slate-200 sticky top-0 z-20">
                <div class="px-8 py-4 flex items-center justify-between">
                    <div class="flex-1 min-w-0">
                        <?php echo e($header ?? ''); ?>

                    </div>

                    <div class="flex items-center gap-4 ml-6">
                        <button class="p-2 text-slate-400 hover:text-indigo-600 transition relative">
                            <i class="ph-bold ph-bell-simple text-xl"></i>
                            <span class="absolute top-2 right-2 h-2 w-2 bg-rose-500 rounded-full border border-white"></span>
                        </button>
                        <div class="h-8 w-px bg-slate-200"></div>

                        <div class="flex items-center gap-3 pl-2">
                            <div class="text-right hidden md:block">
                                <p class="text-xs font-bold text-slate-800"><?php echo e(Auth::user()->name); ?></p>
                                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-wider">Super Admin</p>
                            </div>
                            <div class="h-10 w-10 bg-indigo-600 rounded-xl flex items-center justify-center text-white font-black shadow-lg shadow-indigo-200 ring-2 ring-white">
                                <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <div class="flex-1 overflow-y-auto p-8 scroll-smooth">

                <?php if(session('success')): ?>
                    <div class="mb-6 bg-emerald-50 border border-emerald-200 text-emerald-800 px-4 py-3 rounded-xl flex items-center gap-3 shadow-sm">
                        <i class="ph-fill ph-check-circle text-xl"></i>
                        <span class="font-bold text-sm"><?php echo e(session('success')); ?></span>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="mb-6 bg-rose-50 border border-rose-200 text-rose-800 px-4 py-3 rounded-xl shadow-sm">
                        <ul class="list-disc list-inside text-sm font-bold">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php echo e($slot); ?>


                <div class="mt-12 pt-6 border-t border-slate-200 text-center">
                    <p class="text-xs text-slate-400 font-medium">
                        &copy; <?php echo e(date('Y')); ?> LegalPro SaaS Platform. All systems operational.
                    </p>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
<?php /**PATH /Users/yousaf/Documents/GitHub/law-firm-project/resources/views/components/admin-layout.blade.php ENDPATH**/ ?>